@extends('layouts.app')

@section('title', 'About Us - Cesra Company Limited')

@section('content')
    <style>
        /* ========================================================================== */
        /*           ELEVATED CARD-BASED TIMELINE (FINAL, RELIABLE VERSION)         */
        /* ========================================================================== */

        .timeline-card-item {
            position: relative;
            margin-bottom: 3rem;
            /* 48px */
            width: 100%;
            /* Animation setup */
            opacity: 0;
            transition: opacity 0.6s ease-out, transform 0.6s ease-out;
        }

        .timeline-card-item.is-visible {
            opacity: 1;
            transform: translateY(0);
        }

        .timeline-card-item:not(.is-visible) {
            transform: translateY(30px);
        }


        .timeline-card-content {
            position: relative;
            background-color: white;
            border: 1px solid #e5e7eb;
            /* gray-200 */

            /* rounded-lg */
            padding: 1.5rem;
            /* 24px */
            box-shadow: 0 10px 15px -3px rgb(0 0 0 / 0.05), 0 4px 6px -4px rgb(0 0 0 / 0.05);
            overflow: hidden;
            /* Important for the year background */
        }

        .timeline-card-year {

            font-size: 3rem;
            font-weight: 800;
            color: #a8a8a8;
            z-index: 0;
            line-height: 1;
        }

        [dir="rtl"] .timeline-card-year {
            right: auto;
            left: 1.5rem;
            z-index: 0;
            /* 24px */
        }

        /* The horizontal line and dot connecting the card to the timeline */
        .timeline-card-connector {
            position: absolute;
            top: 1.25rem;
            /* 20px */
            width: 50%;
            height: 1px;
            background-color: #d1d5db;
            /* gray-300 */
            display: none;
            /* Hidden on mobile */
        }

        .timeline-card-dot {
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            width: 1rem;
            /* 16px */
            height: 1rem;
            /* 16px */
            border-radius: 9999px;
            background-color: white;
            border: 3px solid #e82424;
            /* custom-yellow/red */
        }


        /* --- Desktop Layout (md and up: 768px) --- */
        @media (min-width: 768px) {
            .timeline-card-item {
                width: 50%;
            }

            .timeline-card-connector {
                display: block;
                /* Show the connector on desktop */
            }

            /* RIGHT SIDE ITEMS */
            .timeline-card-item:nth-child(odd) {
                padding-right: 2rem;
                /* 32px */
            }

            .timeline-card-item:nth-child(odd) .timeline-card-connector {
                right: 0;
            }

            .timeline-card-item:nth-child(odd) .timeline-card-dot {
                left: -0.5rem;
                /* Position dot over the line */
            }

            /* LEFT SIDE ITEMS */
            .timeline-card-item:nth-child(even) {
                margin-left: 50%;
                padding-left: 2rem;
                /* 32px */
            }

            .timeline-card-item:nth-child(even) .timeline-card-connector {
                left: 0;
            }

            .timeline-card-item:nth-child(even) .timeline-card-dot {
                right: -0.5rem;
                /* Position dot over the line */
            }

            /* Animation Directions */
            .timeline-card-item:nth-child(odd):not(.is-visible) {
                transform: translateX(-30px);
            }

            .timeline-card-item:nth-child(even):not(.is-visible) {
                transform: translateX(30px);
            }

            /* --- RTL Specific overrides --- */
            [dir="rtl"] .timeline-card-item:nth-child(odd) {
                padding-right: 0;
                padding-left: 2rem;
                /* 32px */
            }

            [dir="rtl"] .timeline-card-item:nth-child(odd) .timeline-card-connector {
                right: auto;
                left: 0;
            }

            [dir="rtl"] .timeline-card-item:nth-child(odd) .timeline-card-dot {
                left: auto;
                right: -0.5rem;
            }

            [dir="rtl"] .timeline-card-item:nth-child(even) {
                margin-left: 0;
                margin-right: 50%;
                padding-left: 0;
                padding-right: 2rem;
                /* 32px */
            }

            [dir="rtl"] .timeline-card-item:nth-child(even) .timeline-card-connector {
                left: auto;
                right: 0;
            }

            [dir="rtl"] .timeline-card-item:nth-child(even) .timeline-card-dot {
                right: auto;
                left: -0.5rem;
            }

            /* RTL Animation Directions */
            [dir="rtl"] .timeline-card-item:nth-child(odd):not(.is-visible) {
                transform: translateX(30px);
            }

            [dir="rtl"] .timeline-card-item:nth-child(even):not(.is-visible) {
                transform: translateX(-30px);
            }
        }
    </style>
    <!-- ================== BREADCRUMB/HERO SECTION ================== -->
    <x-page-header title="About Us"
        subtitle="Building the future of Saudi Arabia with a legacy of excellence, integrity, and innovation since 2005."
        image="images/slider/new/2.jpg" />

    <!-- ================== WHO WE ARE INTRODUCTION ================== -->
    <section class="py-20 bg-white">
        <div class="container mx-auto px-4">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-16 items-center">
                <!-- Left Column: Image -->
                <!-- NEW CODE (Contained Zoom) -->
                <div class="relative shadow-2xl animate-on-scroll">
                    <!-- This new div acts as a frame to contain the zoom effect -->
                    <div class="overflow-hidden">
                        <img src="images/6.jpg" alt="Cesra Team Planning a Project"
                            class="w-full h-full object-cover kenburns-image" />
                    </div>
                    <div class="absolute -top-4 -left-4 w-24 h-24 border-t-8 border-l-8 border-custom-yellow"></div>
                    <div class="absolute -bottom-4 -right-4 w-24 h-24 border-b-8 border-r-8 border-custom-yellow"></div>
                </div>

                <!-- Right Column: Text Content -->
                <div class="text-start animate-on-scroll" style="animation-delay: 0.1s;">
                    <p class="text-gray-500 font-medium mb-2">Our Story</p>
                    <h2 class="text-3xl sm:text-4xl md:text-5xl font-extrabold text-custom-secondary leading-tight">
                        Building the Future of Saudi Arabia Since 2005
                    </h2>
                    <div class="w-16 h-1 bg-custom-yellow my-6"></div>
                    <p class="text-gray-600 leading-relaxed text-lg font-semibold">
                        CESRA is a premier EPC contracting company with over two decades of proven experience delivering
                        high-standard construction solutions across the Kingdom of Saudi Arabia.
                    </p>
                    <p class="mt-4 text-gray-600 leading-relaxed">
                        Founded by professionals with deep industry knowledge and a passion for excellence, CESRA has grown
                        into a reliable partner committed to quality, safety, and sustainable development. We specialize in
                        residential, commercial, governmental, and complex infrastructure projects, managing every phase
                        from planning to handover with our fully integrated in-house capabilities.
                    </p>
                    <a href="#history"
                        class="mt-8 inline-block bg-custom-secondary text-white px-8 py-4 hover:bg-black transition-colors">
                        EXPLORE OUR JOURNEY
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- ================== VISION & MISSION SECTION ================== -->
    <section class="py-20 bg-gray-50">
        <div class="container mx-auto px-4">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                <!-- Vision Card -->
                <div class="bg-white p-8 shadow-lg flex items-start gap-6 animate-on-scroll">
                    <div class="flex-shrink-0 text-custom-yellow text-5xl">
                        <i class="fas fa-binoculars"></i>
                    </div>
                    <div>
                        <h3 class="text-3xl font-bold text-custom-secondary">Our Vision</h3>
                        <p class="mt-4 text-gray-600 leading-relaxed">
                            To lead the contracting landscape in Saudi Arabia by delivering cutting-edge, integrated
                            construction solutions that set new standards of excellence, inspire progress, and shape the
                            cities of tomorrow, rooted in the Kingdom's Vision 2030.
                        </p>
                    </div>
                </div>
                <!-- Mission Card -->
                <div class="bg-white p-8 shadow-lg flex items-start gap-6 animate-on-scroll" style="animation-delay: 0.1s;">
                    <div class="flex-shrink-0 text-custom-yellow text-5xl">
                        <i class="fas fa-rocket"></i>
                    </div>
                    <div>
                        <h3 class="text-3xl font-bold text-custom-secondary">Our Mission</h3>
                        <p class="mt-4 text-gray-600 leading-relaxed">
                            To be a reliable national player delivering safe, efficient, and high-quality integrated
                            services. We are committed to meeting our clients' needs through professional execution,
                            technical excellence, and sustainable practices that align with the Kingdom's development goals.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- ================== CORE VALUES SECTION ================== -->
    <section class="py-20 bg-white">
        <div class="container mx-auto px-4 text-center">
            <p class="text-gray-500 font-medium">Our Guiding Principles</p>
            <h2 class="text-3xl sm:text-4xl md:text-5xl font-extrabold text-custom-secondary mt-2 leading-tight">
                Our Core Values
            </h2>
            <div class="w-16 h-1 bg-custom-yellow my-6 mx-auto"></div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 mt-12 text-start">
                <!-- Value 1: Client Focus -->
                <div
                    class="bg-gray-50 p-6 transition-all duration-300 hover:shadow-xl hover:-translate-y-2 animate-on-scroll">
                    <div class="flex items-center gap-4">
                        <div class="text-custom-yellow text-4xl"><i class="fas fa-users"></i></div>
                        <h4 class="text-xl font-bold text-custom-secondary">Client Focus</h4>
                    </div>
                    <p class="mt-4 text-gray-600">We prioritize our clients' goals, building long-term partnerships on
                        trust, transparency, and shared success.</p>
                </div>
                <!-- Value 2: Integrity -->
                <div class="bg-gray-50 p-6 transition-all duration-300 hover:shadow-xl hover:-translate-y-2 animate-on-scroll"
                    style="animation-delay: 0.1s;">
                    <div class="flex items-center gap-4">
                        <div class="text-custom-yellow text-4xl"><i class="fas fa-shield-alt"></i></div>
                        <h4 class="text-xl font-bold text-custom-secondary">Integrity</h4>
                    </div>
                    <p class="mt-4 text-gray-600">We conduct business with honesty and responsibility. Our ethical standards
                        are non-negotiable.</p>
                </div>
                <!-- Value 3: Excellence -->
                <div class="bg-gray-50 p-6 transition-all duration-300 hover:shadow-xl hover:-translate-y-2 animate-on-scroll"
                    style="animation-delay: 0.2s;">
                    <div class="flex items-center gap-4">
                        <div class="text-custom-yellow text-4xl"><i class="fas fa-trophy"></i></div>
                        <h4 class="text-xl font-bold text-custom-secondary">Excellence</h4>
                    </div>
                    <p class="mt-4 text-gray-600">We aim for excellence in everything we do—from design to delivery,
                        exceeding expectations.</p>
                </div>
                <!-- Value 4: Innovation -->
                <div class="bg-gray-50 p-6 transition-all duration-300 hover:shadow-xl hover:-translate-y-2 animate-on-scroll"
                    style="animation-delay: 0.3s;">
                    <div class="flex items-center gap-4">
                        <div class="text-custom-yellow text-4xl"><i class="fas fa-lightbulb"></i></div>
                        <h4 class="text-xl font-bold text-custom-secondary">Innovation</h4>
                    </div>
                    <p class="mt-4 text-gray-600">We embrace new technologies and creative thinking to provide
                        forward-looking solutions that enhance quality.</p>
                </div>
                <!-- Value 5: Teamwork -->
                <div class="bg-gray-50 p-6 transition-all duration-300 hover:shadow-xl hover:-translate-y-2 animate-on-scroll"
                    style="animation-delay: 0.4s;">
                    <div class="flex items-center gap-4">
                        <div class="text-custom-yellow text-4xl"><i class="fas fa-people-carry"></i></div>
                        <h4 class="text-xl font-bold text-custom-secondary">Teamwork</h4>
                    </div>
                    <p class="mt-4 text-gray-600">Collaboration is at the heart of our operations. We work together across
                        all disciplines to deliver better outcomes.</p>
                </div>
                <!-- Value 6: Safety & Sustainability -->
                <div class="bg-gray-50 p-6 transition-all duration-300 hover:shadow-xl hover:-translate-y-2 animate-on-scroll"
                    style="animation-delay: 0.5s;">
                    <div class="flex items-center gap-4">
                        <div class="text-custom-yellow text-4xl"><i class="fas fa-hard-hat"></i></div>
                        <h4 class="text-xl font-bold text-custom-secondary">Safety & Sustainability</h4>
                    </div>
                    <p class="mt-4 text-gray-600">We ensure the safety of our people and the sustainability of our
                        operations, considering the long-term impact of every decision.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- ================== COMPANY HISTORY TIMELINE (ELEVATED CARD DESIGN) ================== -->
    <section id="history" class="py-20 bg-gray-50">
        <div class="container mx-auto px-4">
            <div class="text-center mb-20">
                <p class="text-gray-500 font-medium">Our Milestones</p>
                <h2 class="text-3xl sm:text-4xl md:text-5xl font-extrabold text-custom-secondary mt-2 leading-tight">
                    A Journey of Growth & Excellence
                </h2>
                <div class="w-16 h-1 bg-custom-yellow my-6 mx-auto"></div>
            </div>

            <!-- Timeline Container -->
            <div class="relative max-w-5xl mx-auto">
                <!-- The vertical line -->
                <div class="absolute inset-y-0 w-1 bg-gray-200 left-1/2 -translate-x-1/2 hidden md:block"></div>

                <!-- Timeline Item 1 -->
                <div class="timeline-card-item animate-on-scroll">
                    <div class="timeline-card-connector">
                        <div class="timeline-card-dot"></div>
                    </div>
                    <div class="timeline-card-content">
                        <div class="timeline-card-year">2005</div>
                        <h3 class="font-bold text-custom-secondary text-2xl">The Beginning</h3>
                        <p class="text-gray-600 mt-2 z-10">
                            CESRA was founded in Riyadh, launching with a vision to deliver exceptional contracting services
                            based on engineering precision and unwavering commitment.
                        </p>
                    </div>
                </div>

                <!-- Timeline Item 2 -->
                <div class="timeline-card-item animate-on-scroll">
                    <div class="timeline-card-connector">
                        <div class="timeline-card-dot"></div>
                    </div>
                    <div class="timeline-card-content">
                        <div class="timeline-card-year">2010</div>
                        <h3 class="font-bold text-custom-secondary text-2xl">First Major Infrastructure Project</h3>
                        <p class="text-gray-600 mt-2 z-10">
                            Awarded our first large-scale infrastructure contract, marking a significant step into the
                            public works sector and expanding our technical capabilities.
                        </p>
                    </div>
                </div>

                <!-- Timeline Item 3 -->
                <div class="timeline-card-item animate-on-scroll">
                    <div class="timeline-card-connector">
                        <div class="timeline-card-dot"></div>
                    </div>
                    <div class="timeline-card-content">
                        <div class="timeline-card-year">2015</div>
                        <h3 class="font-bold text-custom-secondary text-2xl">Team Expansion</h3>
                        <p class="text-gray-600 mt-2 z-10">
                            Our in-house team grew to over 100 skilled professionals, enhancing our ability to manage
                            complex projects end-to-end.
                        </p>
                    </div>
                </div>

                <!-- Timeline Item 4 -->
                <div class="timeline-card-item animate-on-scroll">
                    <div class="timeline-card-connector">
                        <div class="timeline-card-dot"></div>
                    </div>
                    <div class="timeline-card-content">
                        <div class="timeline-card-year">2020</div>
                        <h3 class="font-bold text-custom-secondary text-2xl">Aligning with Vision 2030</h3>
                        <p class="text-gray-600 mt-2">
                            CESRA strategically aligned its operations with Saudi Vision 2030, focusing on sustainable
                            development and landmark national projects.
                        </p>
                    </div>
                </div>

                <!-- Timeline Item 5 -->
                <div class="timeline-card-item animate-on-scroll">
                    <div class="timeline-card-connector">
                        <div class="timeline-card-dot"></div>
                    </div>
                    <div class="timeline-card-content">
                        <div class="timeline-card-year">Today</div>
                        <h3 class="font-bold text-custom-secondary text-2xl">A Trusted Leader</h3>
                        <p class="text-gray-600 mt-2">
                            With projects exceeding 450M SAR and a team of over 265 experts, CESRA stands as a trusted
                            leader in the Saudi construction industry.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="py-20 bg-white">
        <div class="container mx-auto px-4 text-center">
            <p class="text-gray-500 font-medium">Our Driving Force</p>
            <h2 class="text-3xl sm:text-4xl md:text-5xl font-extrabold text-custom-secondary mt-2 leading-tight">
                Meet Our Leadership
            </h2>
            <div class="w-16 h-1 bg-custom-yellow my-6 mx-auto"></div>

            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-2 gap-8 max-w-4xl mx-auto mt-12">
                <!-- General Manager -->
                <div class="text-center animate-on-scroll">
                    <div class="relative inline-block">
                        <img src="images/profile/2.jpg" alt="General Manager"
                            class="w-48 h-48 rounded-full object-cover shadow-xl mx-auto border-4 border-white">
                        <div
                            class="absolute bottom-0 right-0 w-12 h-12 bg-custom-yellow text-white flex items-center justify-center rounded-full text-xl">
                            <i class="fas fa-user-tie"></i>
                        </div>
                    </div>
                    <h4 class="mt-4 text-2xl font-bold text-custom-secondary">General Manager</h4>
                    <p class="text-custom-yellow font-semibold">Visionary Leader</p>
                    <p class="mt-2 text-gray-600 max-w-sm mx-auto text-sm">
                        "Since our launch, we have worked diligently to earn our clients' trust by delivering projects that
                        meet the highest standards of engineering and quality."
                    </p>
                </div>
                <!-- Projects Manager -->
                <div class="text-center animate-on-scroll" style="animation-delay: 0.1s;">
                    <div class="relative inline-block">
                        <img src="images/profile/2.jpg" alt="Projects Manager"
                            class="w-48 h-48 rounded-full object-cover shadow-xl mx-auto border-4 border-white">
                        <div
                            class="absolute bottom-0 right-0 w-12 h-12 bg-custom-yellow text-white flex items-center justify-center rounded-full text-xl">
                            <i class="fas fa-tasks"></i>
                        </div>
                    </div>
                    <h4 class="mt-4 text-2xl font-bold text-custom-secondary">Projects Manager</h4>
                    <p class="text-custom-yellow font-semibold">Execution Expert</p>
                    <p class="mt-2 text-gray-600 max-w-sm mx-auto text-sm">
                        "Our success lies in our distinguished human resources. We exceed expectations through transparency,
                        credibility, and commitment to every project."
                    </p>
                </div>
            </div>
        </div>
    </section>


    <!-- ================== FINAL CTA SECTION ================== -->
    <section class="relative bg-custom-secondary py-20 text-white text-center">
        <div class="absolute inset-0 z-0">
            <img src="images/slider/new/1.jpg" alt="Skyscraper construction"
                class="w-full h-full object-cover opacity-20" />
        </div>
        <div class="container mx-auto px-4 relative z-10">
            <h2 class="text-3xl sm:text-4xl md:text-5xl font-extrabold leading-tight max-w-3xl mx-auto">
                Ready to Build Your Next Landmark Project?
            </h2>
            <p class="mt-4 text-gray-300 max-w-2xl mx-auto">
                Partner with a contractor that brings experience, innovation, and a commitment to excellence. Let's build
                the future together.
            </p>
            <a href="/contact"
                class="mt-8 inline-block bg-custom-yellow text-white px-10 py-4 hover:bg-white hover:text-custom-secondary font-bold transition-colors">
                GET IN TOUCH
            </a>
        </div>
    </section>
    <script>
        // This script handles all page-specific animations.
        // It uses an Intersection Observer to add a '.is-visible' class when an element scrolls into view.
        // This is more performant than scroll event listeners.
        document.addEventListener('DOMContentLoaded', () => {
            // 1. General scroll-in animations for cards, text blocks, etc.
            const animatedElements = document.querySelectorAll('.animate-on-scroll, .history-timeline-v2__item');
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.classList.add('is-visible');
                        // Optional: stop observing after it's visible to save resources
                        // observer.unobserve(entry.target);
                    }
                });
            }, {
                threshold: 0.1
            }); // Trigger when 10% of the element is visible

            animatedElements.forEach(el => observer.observe(el));

            // 2. Animated number counter for the statistics bar
            const statsBar = document.getElementById('stats-bar');
            // We only want this to run once, so we'll track if it has run
            let counterAnimated = false;

            const counterObserver = new IntersectionObserver((entries) => {
                if (entries[0].isIntersecting && !counterAnimated) {
                    counterAnimated = true; // Mark as animated
                    const counters = statsBar.querySelectorAll('.counter-number');
                    counters.forEach(counter => {
                        counter.innerText = '0'; // Reset to 0 before starting
                        const updateCount = () => {
                            const target = +counter.getAttribute('data-target');
                            const count = +counter.innerText;
                            const increment = target /
                                150; // Adjust speed of animation (lower number is faster)

                            if (count < target) {
                                counter.innerText = `${Math.ceil(count + increment)}`;
                                setTimeout(updateCount, 10); // Adjust timing
                            } else {
                                counter.innerText =
                                    target; // Ensure it ends on the exact target number
                            }
                        };
                        updateCount();
                    });
                    counterObserver.unobserve(statsBar); // Stop observing after animation
                }
            }, {
                threshold: 0.8
            }); // Trigger when 80% of the bar is visible

            if (statsBar) {
                counterObserver.observe(statsBar);
            }
        });
    </script>
@endsection
