@props([
    'title',
    'subtitle' => null, // Subtitle is optional
    'image',
])

<section class="relative h-[30vh] min-h-[300px] text-white flex items-center justify-center text-center">
    <!-- Jarallax Parallax Background -->
    <div class="jarallax absolute inset-0 z-0">
        {{-- Dynamic background image --}}
        <img class="jarallax-img" src="{{ asset($image) }}" alt="{{ $title }} page header">

        <!-- Dark Overlay Gradient (Black → Transparent, Bottom → Top) -->
        <div class="absolute inset-0 bg-gradient-to-t from-black via-black/40 to-transparent"></div>
    </div>

    <!-- Content -->
    <div class="relative z-10 container mx-auto px-4 animate-on-scroll">
        <h1 class="text-4xl sm:text-5xl md:text-6xl font-extrabold tracking-tight drop-shadow-lg">
            {{ $title }}
        </h1>

        <!-- Optional Subtitle -->
        {{-- @if ($subtitle)
            <p class="mt-3 text-lg sm:text-xl text-gray-200">{{ $subtitle }}</p>
        @endif --}}

        <!-- Breadcrumb Navigation -->
        <div class="mt-8 text-sm font-medium tracking-wider uppercase">
            <a href="/" class="text-gray-300 hover:text-custom-yellow transition-colors">Home</a>
            <span class="mx-2 text-gray-500">/</span>
            <span class="text-white">{{ $title }}</span>
        </div>
    </div>
</section>
