@extends('layouts.app')

@section('title', 'Contact Us - Cesra Company Limited')

@section('content')

    <x-page-header title="Contact Us"
        subtitle="We're here to answer your questions and help bring your next project to life. Reach out to us through any of the channels below."
        image="images/bg/4.jpg" />

    <section class="py-20 bg-white">
        <div class="container mx-auto px-4">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12">

                <div class="animate-on-scroll">
                    <h2 class="text-3xl font-extrabold text-custom-secondary">Get In Touch</h2>
                    <div class="w-16 h-1 bg-custom-yellow my-4"></div>
                    <p class="text-gray-600 leading-relaxed mb-8">
                        Whether you have a question about our services, a project proposal, or a media inquiry, our team is
                        ready to assist you. Please feel free to contact us via phone, email, or by filling out the form.
                    </p>

                    <div class="space-y-6">
                        <!-- Address -->
                        <div class="flex items-start gap-5">
                            <div
                                class="flex-shrink-0 w-12 h-12 bg-custom-yellow/10 text-custom-yellow rounded-full flex items-center justify-center text-xl">
                                <i class="fas fa-map-marker-alt"></i>
                            </div>
                            <div>
                                <h4 class="font-bold text-lg text-custom-secondary">Our Office</h4>
                                <p class="text-gray-600">3393 Al Ajluni Street, RCWA3393<br>Al Wizarat, Riyadh 12622-8321,
                                    KSA</p>
                            </div>
                        </div>
                        <!-- Email -->
                        <div class="flex items-start gap-5">
                            <div
                                class="flex-shrink-0 w-12 h-12 bg-custom-yellow/10 text-custom-yellow rounded-full flex items-center justify-center text-xl">
                                <i class="fas fa-envelope-open-text"></i>
                            </div>
                            <div>
                                <h4 class="font-bold text-lg text-custom-secondary">Email Us</h4>
                                <a href="mailto:info@cesra.com.sa"
                                    class="text-gray-600 hover:text-custom-yellow transition-colors">info@cesra.com.sa</a>
                            </div>
                        </div>
                        <!-- Phone -->
                        <div class="flex items-start gap-5">
                            <div
                                class="flex-shrink-0 w-12 h-12 bg-custom-yellow/10 text-custom-yellow rounded-full flex items-center justify-center text-xl">
                                <i class="fas fa-phone-alt"></i>
                            </div>
                            <div>
                                <h4 class="font-bold text-lg text-custom-secondary">Call Us</h4>
                                <a href="tel:+966114769640"
                                    class="text-gray-600 hover:text-custom-yellow transition-colors">+966 11 476 9640</a>
                            </div>
                        </div>
                    </div>

                    <!-- Social Media -->
                    <div class="mt-10 pt-6 border-t">
                        <h4 class="font-semibold text-custom-secondary mb-4">Follow Us:</h4>
                        <div class="flex items-center gap-2">
                            <a href="#"
                                class="w-10 h-10 flex items-center justify-center bg-gray-100 text-gray-500 rounded-full transition-all duration-300 hover:bg-custom-secondary hover:text-white hover:scale-110"><i
                                    class="fab fa-facebook-f"></i></a>
                            <a href="#"
                                class="w-10 h-10 flex items-center justify-center bg-gray-100 text-gray-500 rounded-full transition-all duration-300 hover:bg-custom-secondary hover:text-white hover:scale-110"><i
                                    class="fab fa-twitter"></i></a>
                            <a href="#"
                                class="w-10 h-10 flex items-center justify-center bg-gray-100 text-gray-500 rounded-full transition-all duration-300 hover:bg-custom-secondary hover:text-white hover:scale-110"><i
                                    class="fab fa-linkedin-in"></i></a>
                            <a href="#"
                                class="w-10 h-10 flex items-center justify-center bg-gray-100 text-gray-500 rounded-full transition-all duration-300 hover:bg-custom-secondary hover:text-white hover:scale-110"><i
                                    class="fab fa-instagram"></i></a>
                        </div>
                    </div>
                </div>

                <!-- Right Column: Contact Form -->
                <div class="bg-gray-50 p-8 rounded-lg shadow-lg animate-on-scroll">
                    <h2 class="text-3xl font-extrabold text-custom-secondary">Send Us a Message</h2>
                    <div class="w-16 h-1 bg-custom-yellow my-4"></div>
                    <form action="#" method="POST" class="mt-6 space-y-6">
                        @csrf

                        <!-- Name & Email -->
                        <div class="grid grid-cols-1 sm:grid-cols-2 gap-6">
                            <div>
                                <label for="name" class="block text-sm font-semibold text-gray-700 mb-1">Full
                                    Name</label>
                                <input type="text" name="name" id="name" required
                                    class="block w-full rounded-lg border border-gray-300 bg-gray-50 text-gray-800 text-base py-3.5 px-4 
                       focus:outline-none focus:ring-2 focus:ring-custom-yellow focus:border-custom-yellow transition-all duration-300">
                            </div>

                            <div>
                                <label for="email" class="block text-sm font-semibold text-gray-700 mb-1">Email
                                    Address</label>
                                <input type="email" name="email" id="email" required
                                    class="block w-full rounded-lg border border-gray-300 bg-gray-50 text-gray-800 text-base py-3.5 px-4 
                       focus:outline-none focus:ring-2 focus:ring-custom-yellow focus:border-custom-yellow transition-all duration-300">
                            </div>
                        </div>

                        <!-- Phone & Subject -->
                        <div class="grid grid-cols-1 sm:grid-cols-2 gap-6">
                            <div>
                                <label for="phone" class="block text-sm font-semibold text-gray-700 mb-1">Phone
                                    Number</label>
                                <input type="tel" name="phone" id="phone"
                                    class="block w-full rounded-lg border border-gray-300 bg-gray-50 text-gray-800 text-base py-3.5 px-4 
                       focus:outline-none focus:ring-2 focus:ring-custom-yellow focus:border-custom-yellow transition-all duration-300">
                            </div>

                            <div>
                                <label for="subject" class="block text-sm font-semibold text-gray-700 mb-1">Subject</label>
                                <input type="text" name="subject" id="subject" required
                                    class="block w-full rounded-lg border border-gray-300 bg-gray-50 text-gray-800 text-base py-3.5 px-4 
                       focus:outline-none focus:ring-2 focus:ring-custom-yellow focus:border-custom-yellow transition-all duration-300">
                            </div>
                        </div>

                        <!-- Message -->
                        <div>
                            <label for="message" class="block text-sm font-semibold text-gray-700 mb-1">Message</label>
                            <textarea name="message" id="message" rows="5" required
                                class="block w-full rounded-lg border border-gray-300 bg-gray-50 text-gray-800 text-base py-3.5 px-4 
                   focus:outline-none focus:ring-2 focus:ring-custom-yellow focus:border-custom-yellow transition-all duration-300"></textarea>
                        </div>

                        <!-- Submit Button -->
                        <div>
                            <button type="submit"
                                class="w-full mt-2 bg-custom-yellow text-white px-6 py-4 rounded-lg text-lg font-semibold 
                   hover:bg-custom-secondary transition-all duration-300 shadow-md hover:shadow-lg">
                                Send Message
                            </button>
                        </div>
                    </form>

                </div>

            </div>
        </div>
    </section>

    <!-- ================== MAP SECTION ================== -->
    <section>
        <div class="w-full h-[500px]">
            {{-- IMPORTANT: Replace this src with your actual Google Maps embed link --}}
            <iframe
                src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3624.471676821361!2d46.711867215000005!3d24.710719884125!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3e2f03c2b8c5487f%3A0x8a6e3b2e2d3b5b1a!2sAl%20Wizarat%2C%20Riyadh%20Saudi%20Arabia!5e0!3m2!1sen!2sus!4v1624640000000!5m2!1sen!2sus"
                width="100%" height="100%" style="border:0;" allowfullscreen="" loading="lazy"
                class="filter grayscale-[80%] hover:grayscale-0 transition-all duration-500">
            </iframe>
        </div>
    </section>
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            // Initialize Jarallax for the header
            jarallax(document.querySelectorAll('.jarallax'), {
                speed: 0.4
            });

            // Initialize on-scroll animations
            const animatedElements = document.querySelectorAll('.animate-on-scroll');
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.classList.add('is-visible');
                    }
                });
            }, {
                threshold: 0.1
            });
            animatedElements.forEach(el => observer.observe(el));
        });
    </script>
@endsection
