 <header x-data="{ open: false, langOpen: false, currentLang: 'EN' }">
     <!-- Top Bar -->
     <div class="bg-custom-secondary text-gray-300 text-sm hidden md:block">
         <div class="container mx-auto px-4 py-2 flex justify-between items-center">
             <div class="flex items-center space-x-4 rtl:space-x-reverse">
                 <div class="flex items-center space-x-2 rtl:space-x-reverse">
                     <i class="fas fa-envelope text-custom-yellow"></i><span>info@cesra.com.sa</span>
                 </div>
                 <span class="text-gray-600">|</span>
                 <div class="flex items-center space-x-2 rtl:space-x-reverse">
                     <i class="fas fa-map-marker-alt text-custom-yellow"></i>
                     <span>3393 Al Ajluni Street, RCWA3393 Al Wizarat, Riyadh 12622-8321,
                         KSA</span>
                 </div>
                 <span class="text-gray-600">|</span>
                 <div class="flex items-center space-x-2 rtl:space-x-reverse">
                     <i class="fas fa-phone-alt text-custom-yellow"></i><span>+966 11 476 9640</span>
                 </div>
             </div>
             <div class="flex items-center space-x-4 rtl:space-x-reverse">
                 <a href="#"
                     class="flex items-center space-x-2 rtl:space-x-reverse hover:text-custom-yellow transition-colors">
                     <i class="fas fa-user"></i><span>SIGN IN</span>
                 </a>
                 <div class="flex space-x-1 rtl:space-x-reverse">
                     <a href="#" class="w-8 h-8 flex items-center justify-center social-icon"><i
                             class="fab fa-facebook-f"></i></a>
                     <a href="#" class="w-8 h-8 flex items-center justify-center social-icon"><i
                             class="fab fa-twitter"></i></a>
                     <a href="#" class="w-8 h-8 flex items-center justify-center social-icon"><i
                             class="fab fa-instagram"></i></a>
                     <a href="#" class="w-8 h-8 flex items-center justify-center social-icon"><i
                             class="fab fa-vk"></i></a>
                     <a href="#" class="w-8 h-8 flex items-center justify-center social-icon"><i
                             class="fab fa-pinterest"></i></a>
                 </div>
             </div>
         </div>
     </div>

     <!-- Main Navigation -->
     <nav class="bg-white shadow-md sticky top-0 z-50">
         <div class="container mx-auto px-4 flex justify-between items-center py-2">
             <!-- Logo -->
             <a href="#" class="text-2xl font-bold">
                 <img src="<?php echo e(asset('images/logo/cesra.png')); ?>" alt="Roof Logo" class="h-20">

             </a>

             <!-- Desktop Menu -->
             <div class="hidden lg:flex items-center space-x-8 rtl:space-x-reverse text-custom-secondary">
                 <a href="<?php echo e(url('/')); ?>"
                     class="nav-link <?php echo e(request()->is('/') ? 'text-custom-yellow font-semibold' : 'hover:text-custom-yellow'); ?>">
                     HOME
                 </a>

                 <a href="<?php echo e(url('/about')); ?>"
                     class="nav-link <?php echo e(request()->is('about') ? 'text-custom-yellow font-semibold' : 'hover:text-custom-yellow'); ?>">
                     ABOUT US
                 </a>

                 <a href="<?php echo e(url('/services')); ?>"
                     class="nav-link <?php echo e(request()->is('services') ? 'text-custom-yellow font-semibold' : 'hover:text-custom-yellow'); ?>">
                     SERVICES
                 </a>

                 <a href="<?php echo e(url('/projects')); ?>"
                     class="nav-link <?php echo e(request()->is('projects') ? 'text-custom-yellow font-semibold' : 'hover:text-custom-yellow'); ?>">
                     PROJECTS
                 </a>

                 <a href="<?php echo e(url('/supplier')); ?>"
                     class="nav-link <?php echo e(request()->is('supplier') ? 'text-custom-yellow font-semibold' : 'hover:text-custom-yellow'); ?>">
                     SUPPLIER
                 </a>

                 <a href="<?php echo e(url('/insights')); ?>"
                     class="nav-link <?php echo e(request()->is('insights') ? 'text-custom-yellow font-semibold' : 'hover:text-custom-yellow'); ?>">
                     INSIGHTS
                 </a>

                 <a href="<?php echo e(url('/careers')); ?>"
                     class="nav-link <?php echo e(request()->is('careers') ? 'text-custom-yellow font-semibold' : 'hover:text-custom-yellow'); ?>">
                     CAREERS
                 </a>
             </div>


             <!-- Right Section -->
             <div class="flex items-center space-x-4 rtl:space-x-reverse">
                 <!-- Language Switcher -->
                 <div class="relative" @click.outside="langOpen = false">
                     <button @click="langOpen = !langOpen"
                         class="flex items-center gap-1 text-custom-secondary hover:text-custom-yellow">
                         <span x-text="currentLang"></span>
                         <i class="fas fa-chevron-down text-xs"></i>
                     </button>

                     <div x-show="langOpen" x-transition
                         class="absolute mt-2 right-0 w-28 bg-white border rounded shadow-md">
                         <!-- EN Option -->
                         <button
                             @click="
        currentLang = 'EN'; 
        langOpen = false; 
        document.documentElement.setAttribute('dir', 'ltr'); 
        document.documentElement.classList.remove('rtl');"
                             class="block w-full text-left px-4 py-2 hover:bg-gray-100">
                             EN 🇺🇸
                         </button>

                         <!-- AR Option -->
                         <button
                             @click="
        currentLang = 'AR'; 
        langOpen = false; 
        document.documentElement.setAttribute('dir', 'rtl'); 
        document.documentElement.classList.add('rtl');"
                             class="block w-full text-left px-4 py-2 hover:bg-gray-100">
                             AR 🇸🇦
                         </button>
                     </div>
                 </div>

                 <!-- Contact Button -->
                 <a href="/contact"
                     class="bg-custom-yellow text-white px-6 py-3 hover:bg-custom-secondary transition-colors hidden sm:inline-block">
                     Contact Us
                 </a>

                 <!-- Hamburger -->
                 <button @click="open = !open" class="lg:hidden text-2xl text-custom-secondary focus:outline-none">
                     <i :class="open ? 'fas fa-times' : 'fas fa-bars'"></i>
                 </button>
             </div>
         </div>

         <!-- Mobile Menu -->
         <div x-show="open" x-transition class="lg:hidden bg-white border-t shadow-md">
             <div class="flex flex-col p-4 space-y-4 text-custom-secondary">
                 <a href="<?php echo e(url('/')); ?>"
                     class="nav-link <?php echo e(request()->is('/') ? 'text-custom-yellow font-semibold' : 'hover:text-custom-yellow'); ?>">
                     HOME
                 </a>

                 <a href="<?php echo e(url('/about')); ?>"
                     class="nav-link <?php echo e(request()->is('about') ? 'text-custom-yellow font-semibold' : 'hover:text-custom-yellow'); ?>">
                     ABOUT US
                 </a>

                 <a href="<?php echo e(url('/services')); ?>"
                     class="nav-link <?php echo e(request()->is('services') ? 'text-custom-yellow font-semibold' : 'hover:text-custom-yellow'); ?>">
                     SERVICES
                 </a>

                 <a href="<?php echo e(url('/projects')); ?>"
                     class="nav-link <?php echo e(request()->is('projects') ? 'text-custom-yellow font-semibold' : 'hover:text-custom-yellow'); ?>">
                     PROJECTS
                 </a>

                 <a href="<?php echo e(url('/supplier')); ?>"
                     class="nav-link <?php echo e(request()->is('supplier') ? 'text-custom-yellow font-semibold' : 'hover:text-custom-yellow'); ?>">
                     SUPPLIER
                 </a>

                 <a href="<?php echo e(url('/insights')); ?>"
                     class="nav-link <?php echo e(request()->is('insights') ? 'text-custom-yellow font-semibold' : 'hover:text-custom-yellow'); ?>">
                     INSIGHTS
                 </a>

                 <a href="<?php echo e(url('/careers')); ?>"
                     class="nav-link <?php echo e(request()->is('careers') ? 'text-custom-yellow font-semibold' : 'hover:text-custom-yellow'); ?>">
                     CAREERS
                 </a>
             </div>
         </div>

     </nav>
 </header>
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/theroof/cesra/resources/views/partials/header.blade.php ENDPATH**/ ?>