<?php $__env->startSection('title', 'CESRA Completes Landmark Shaqra Wastewater Treatment Plant - Cesra Insights'); ?>

<?php $__env->startSection('content'); ?>

    <style>
        /* Styles for the redesigned "Glass" Sidebar */
        .sidebar-widget {
            background: rgba(255, 255, 255, 0.5);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.7);

            padding: 1.5rem;
            box-shadow: 0 4px 6px -1px rgb(0 0 0 / 0.05);
        }

        .sidebar-title {
            font-weight: 800;
            font-size: 1.25rem;
            color: #2c3a5a;
            margin-bottom: 1rem;
            padding-bottom: 0.75rem;
            border-bottom: 1px solid #e5e7eb;
        }

        .sidebar-category-link {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0.5rem 0;
            color: #4b5563;
            transition: color 0.3s ease;
        }

        .sidebar-category-link:hover {
            color: #e82424;
        }

        .sidebar-category-link.active {
            color: #e82424;
            font-weight: 700;
        }

        /* Styles for the article content for better readability */
        .article-content h2 {
            @apply text-3xl font-bold text-custom-secondary mt-8 mb-4;
        }

        .article-content p {
            @apply text-gray-700 leading-relaxed mb-6;
        }

        .article-content ul {
            @apply list-disc list-inside space-y-2 mb-6 pl-4;
        }

        .article-content blockquote {
            @apply border-l-4 border-custom-yellow pl-6 py-4 my-6 bg-gray-50 text-lg italic text-gray-800;
        }
    </style>

    <section class="relative h-[45vh] min-h-[350px] text-white flex items-center justify-center text-center">
        <div class="jarallax absolute inset-0 z-0">
            <img class="jarallax-img" src="<?php echo e(asset('images/bg/1.jpg')); ?>" alt="Shaqra Wastewater Treatment Plant">

            <!-- THIS IS THE CORRECTED LINE -->
            <div class="absolute inset-0 bg-gradient-to-t from-black/80 to-transparent"></div>

        </div>
        <div class="relative z-10 container mx-auto px-4 animate-on-scroll">
            <div class="flex justify-center items-center gap-4 mb-4">
                <span class="bg-custom-yellow text-white text-xs font-bold uppercase px-3 py-1 ">Project
                    Updates</span>
                <span class="text-gray-300">&bull;</span>
                <span class="text-gray-300">June 20, 2025</span>
            </div>
            <h1 class="text-3xl sm:text-4xl md:text-5xl font-extrabold tracking-tight max-w-4xl mx-auto">
                CESRA Completes Landmark Shaqra Wastewater Treatment Plant
            </h1>
            <div class="mt-8 text-sm font-medium tracking-wider uppercase">
                <a href="/" class="text-gray-300 hover:text-custom-yellow transition-colors">Home</a>
                <span class="mx-2 text-gray-500">/</span>
                <a href="/insights" class="text-gray-300 hover:text-custom-yellow transition-colors">Insights</a>
                <span class="mx-2 text-gray-500">/</span>
                <span class="text-white">Article</span>
            </div>
        </div>
    </section>

    <!-- ================== BLOG POST & SIDEBAR SECTION ================== -->
    <section class="py-20 bg-gray-100" x-data="insights_page()">
        <div class="container mx-auto px-4">
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8 lg:gap-12">

                <!-- =================== REPLACEMENT <article> BLOCK (PURE TAILWIND CSS) =================== -->

                <article class="lg:col-span-2 bg-white shadow-lg overflow-hidden">
                    <!-- Full-width Featured Image for the Article -->
                    <img src="<?php echo e(asset('images/bg/3.jpg')); ?>" alt="Inside the Shaqra Plant"
                        class="w-full h-96 object-cover">

                    <div class="p-8 md:p-12">
                        <div class="article-content">
                            <!-- First Paragraph with Drop Cap -->
                            <p class="mb-6 text-lg leading-loose text-gray-700">
                                <span
                                    class="float-left rtl:float-right text-7xl font-extrabold text-custom-yellow mr-4 rtl:ml-4 mt-1 leading-none">A</span>significant
                                leap toward enhancing environmental sustainability, the successful completion of the Shaqra
                                plant expansion marks a key milestone in our commitment to Saudi Vision 2030. This project
                                showcases our technical expertise in large-scale infrastructure and water management.
                            </p>

                            <p class="mb-6 text-lg leading-loose text-gray-700">The expansion project, which began over two
                                years ago, involved the implementation of state-of-the-art tertiary treatment facilities,
                                SCADA system installation, and the construction of new biological and settling basins. Our
                                team of over 50 engineers and technicians worked diligently to overcome complex logistical
                                challenges and deliver the project ahead of schedule.</p>

                            <!-- Redesigned Blockquote -->
                            <blockquote class="relative my-10 pl-16 rtl:pl-0 rtl:pr-16">
                                <div class="absolute left-0 rtl:left-auto rtl:right-0 top-0 text-6xl text-gray-200">
                                    <i class="fas fa-quote-left rtl:hidden"></i>
                                    <i class="fas fa-quote-right hidden rtl:block"></i>
                                </div>
                                <p class="text-xl italic text-gray-800">"This project is more than just an infrastructure
                                    upgrade; it's a testament to our dedication to building a sustainable future for the
                                    Kingdom. We are incredibly proud of our team's achievement."</p>
                                <cite class="block mt-4 text-base not-italic font-semibold text-custom-secondary">- General
                                    Manager, Cesra</cite>
                            </blockquote>

                            <!-- Stylized Heading -->
                            <h2
                                class="text-3xl font-extrabold text-custom-secondary mt-10 mb-5 border-l-4 rtl:border-l-0 rtl:border-r-4 border-custom-yellow pl-4 rtl:pl-0 rtl:pr-4">
                                Key Project Highlights</h2>

                            <!-- Custom Styled List -->
                            <ul class="space-y-4 mb-8 text-lg">
                                <li class="flex items-start">
                                    <span
                                        class="flex-shrink-0 w-6 h-6 bg-custom-yellow text-white rounded-full flex items-center justify-center mr-4 rtl:mr-0 rtl:ml-4 mt-1">
                                        <i class="fas fa-check text-xs"></i>
                                    </span>
                                    <span>Increased treatment capacity by 150%, serving an additional 100,000
                                        residents.</span>
                                </li>
                                <li class="flex items-start">
                                    <span
                                        class="flex-shrink-0 w-6 h-6 bg-custom-yellow text-white rounded-full flex items-center justify-center mr-4 rtl:mr-0 rtl:ml-4 mt-1">
                                        <i class="fas fa-check text-xs"></i>
                                    </span>
                                    <span>Implementation of advanced SCADA systems for optimized operational
                                        efficiency.</span>
                                </li>
                                <li class="flex items-start">
                                    <span
                                        class="flex-shrink-0 w-6 h-6 bg-custom-yellow text-white rounded-full flex items-center justify-center mr-4 rtl:mr-0 rtl:ml-4 mt-1">
                                        <i class="fas fa-check text-xs"></i>
                                    </span>
                                    <span>Construction of new chlorine contact basins to ensure the highest water quality
                                        standards.</span>
                                </li>
                            </ul>

                            <h2
                                class="text-3xl font-extrabold text-custom-secondary mt-10 mb-5 border-l-4 rtl:border-l-0 rtl:border-r-4 border-custom-yellow pl-4 rtl:pl-0 rtl:pr-4">
                                A Commitment to Vision 2030</h2>
                            <p class="mb-6 text-lg leading-loose text-gray-700">Projects like the Shaqra plant are central
                                to the goals of Saudi Vision 2030, which emphasizes sustainable development and resource
                                management. By investing in modern water infrastructure, CESRA is not only improving public
                                health but also contributing to the Kingdom's long-term environmental resilience and
                                economic diversification.</p>
                        </div>

                        <!-- Social Share & Tags -->
                        <div
                            class="mt-12 pt-8 border-t flex flex-col sm:flex-row items-start sm:items-center justify-between gap-6">
                            <div class="flex items-center gap-3">
                                <h4 class="font-bold text-custom-secondary flex-shrink-0">Tags:</h4>
                                <div class="flex flex-wrap gap-2">
                                    <a href="#"
                                        class="px-3 py-1 bg-gray-100 text-gray-600 text-sm rounded-full hover:bg-gray-200 transition-colors">Infrastructure</a>
                                    <a href="#"
                                        class="px-3 py-1 bg-gray-100 text-gray-600 text-sm rounded-full hover:bg-gray-200 transition-colors">Vision
                                        2030</a>
                                </div>
                            </div>
                            <div class="flex items-center gap-2">
                                <a href="#"
                                    class="w-10 h-10 flex items-center justify-center bg-gray-100 text-gray-500 rounded-full transition-all duration-300 hover:bg-custom-secondary hover:text-white hover:scale-110"><i
                                        class="fab fa-facebook-f"></i></a>
                                <a href="#"
                                    class="w-10 h-10 flex items-center justify-center bg-gray-100 text-gray-500 rounded-full transition-all duration-300 hover:bg-custom-secondary hover:text-white hover:scale-110"><i
                                        class="fab fa-twitter"></i></a>
                                <a href="#"
                                    class="w-10 h-10 flex items-center justify-center bg-gray-100 text-gray-500 rounded-full transition-all duration-300 hover:bg-custom-secondary hover:text-white hover:scale-110"><i
                                        class="fab fa-linkedin-in"></i></a>
                                <a href="#"
                                    class="w-10 h-10 flex items-center justify-center bg-gray-100 text-gray-500 rounded-full transition-all duration-300 hover:bg-custom-secondary hover:text-white hover:scale-110"><i
                                        class="fas fa-link"></i></a>
                            </div>
                        </div>
                    </div>
                </article>


                <!-- ============== REUSED SIDEBAR ============== -->
                <aside class="lg:col-span-1 space-y-8">
                    <!-- Search Widget -->
                    <div class="sidebar-widget">
                        <h3 class="sidebar-title">Search</h3>
                        <div class="relative">
                            <input type="text" x-model.debounce.300ms="search_term" placeholder="Type to search..."
                                class="w-full border-gray-300 rounded-md shadow-inner focus:ring-custom-yellow focus:border-custom-yellow">
                            <i class="fas fa-search absolute top-1/2 right-4 -translate-y-1/2 text-gray-400"></i>
                        </div>
                    </div>

                    <!-- Categories Widget -->
                    <div class="sidebar-widget">
                        <h3 class="sidebar-title">Categories</h3>
                        <ul class="space-y-1">
                            <li><a @click.prevent="category_filter = 'all'; window.location.href='/insights'" href="#"
                                    class="sidebar-category-link"><span class="font-bold">All</span> <span
                                        x-text="posts.length"></span></a></li>
                            <template x-for="category in categories" :key="category.name">
                                <li><a @click.prevent="category_filter = category.name; window.location.href='/insights?category=' + category.name.toLowerCase()"
                                        href="#" class="sidebar-category-link"><span x-text="category.name"></span>
                                        <span x-text="category.count"></span></a></li>
                            </template>
                        </ul>
                    </div>

                    <!-- Recent Posts Widget -->
                    <div class="sidebar-widget">
                        <h3 class="sidebar-title">Recent Posts</h3>
                        <ul class="space-y-5">
                            <template x-for="post in posts.slice(0, 3)" :key="post.id">
                                <li class="flex items-center gap-4 group">
                                    <a href="#" class="flex-shrink-0 block w-20 h-20 overflow-hidden">
                                        <img :src="post.image" :alt="post.title"
                                            class="w-full h-full object-cover transform group-hover:scale-110 transition-transform duration-300">
                                    </a>
                                    <div>
                                        <p class="text-xs text-gray-500" x-text="post.date"></p>
                                        <a href="#"
                                            class="font-bold text-sm leading-tight text-custom-secondary group-hover:text-custom-yellow transition-colors"
                                            x-text="post.title"></a>
                                    </div>
                                </li>
                            </template>
                        </ul>
                    </div>
                </aside>
            </div>
        </div>
    </section>
    <script>
        function insights_page() {
            return {
                search_term: '',
                category_filter: 'all',
                posts: [{
                        id: 2,
                        title: 'Innovations in Sustainable Construction Materials',
                        category: 'Technology',
                        date: 'June 15, 2025',
                        image: '<?php echo e(asset('images/bg/1.jpg')); ?>'
                    },
                    {
                        id: 3,
                        title: 'The Role of BIM in Modern Project Management',
                        category: 'Technology',
                        date: 'May 28, 2025',
                        image: '<?php echo e(asset('images/bg/2.jpg')); ?>'
                    },
                    {
                        id: 4,
                        title: 'Safety First: Our Unwavering Commitment to HSE Standards',
                        category: 'Company News',
                        date: 'May 10, 2025',
                        image: '<?php echo e(asset('images/bg/3.jpg')); ?>'
                    },
                    {
                        id: 5,
                        title: 'NEOM & The Future of Urban Infrastructure in KSA',
                        category: 'Technology',
                        date: 'April 22, 2025',
                        image: '<?php echo e(asset('images/bg/4.jpg')); ?>'
                    },
                ],
                get categories() {
                    const counts = this.posts.reduce((acc, post) => {
                        acc[post.category] = (acc[post.category] || 0) + 1;
                        return acc;
                    }, {});
                    return Object.keys(counts).map(name => ({
                        name,
                        count: counts[name]
                    }));
                },
            }
        }

        // Jarallax initializer for the header
        document.addEventListener('DOMContentLoaded', () => {
            jarallax(document.querySelectorAll('.jarallax'), {
                speed: 0.4
            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/theroof/cesra/resources/views/insights/show.blade.php ENDPATH**/ ?>