document.addEventListener("DOMContentLoaded", function () {
  const slides = document.querySelectorAll(".slide");
  const nextBtn = document.getElementById("next");
  const prevBtn = document.getElementById("prev");
  const pauseBtn = document.getElementById("pause");
  const paginationContainer = document.getElementById("pagination");

  let currentSlide = 0;
  let slideInterval;
  let isPaused = false;

  // Create pagination dots
  slides.forEach((slide, index) => {
    const dot = document.createElement("button");
    dot.classList.add(
      "h-2",
      "w-2",
      "rounded-full",
      "transition-colors",
      "duration-300"
    );
    dot.classList.add(
      index === 0 ? "bg-custom-yellow" : "bg-gray-500",
      "hover:bg-custom-yellow"
    );
    dot.addEventListener("click", () => {
      goToSlide(index);
      resetInterval();
    });
    paginationContainer.appendChild(dot);
  });

  const paginationDots = paginationContainer.querySelectorAll("button");

  function goToSlide(slideNumber) {
    slides[currentSlide].classList.remove("active");
    slides[currentSlide].classList.add("opacity-0");
    paginationDots[currentSlide].classList.replace(
      "bg-custom-yellow",
      "bg-gray-500"
    );

    currentSlide = (slideNumber + slides.length) % slides.length;

    slides[currentSlide].classList.add("active");
    slides[currentSlide].classList.remove("opacity-0");
    paginationDots[currentSlide].classList.replace(
      "bg-gray-500",
      "bg-custom-yellow"
    );
  }

  function nextSlide() {
    goToSlide(currentSlide + 1);
  }

  function prevSlide() {
    goToSlide(currentSlide - 1);
  }

  function resetInterval() {
    clearInterval(slideInterval);
    if (!isPaused) {
      slideInterval = setInterval(nextSlide, 7000); // Autoplay every 7 seconds
    }
  }

  // Event Listeners
  nextBtn.addEventListener("click", () => {
    nextSlide();
    resetInterval();
  });
  prevBtn.addEventListener("click", () => {
    prevSlide();
    resetInterval();
  });

  pauseBtn.addEventListener("click", () => {
    isPaused = !isPaused;
    pauseBtn.innerHTML = isPaused
      ? '<i class="fas fa-play"></i>'
      : '<i class="fas fa-pause"></i>';
    resetInterval();
  });

  // Start autoplay
  resetInterval();
});

// Add this script just before the closing </body> tag

document.addEventListener("DOMContentLoaded", function () {
  const track = document.getElementById("stats-track");
  const prevBtn = document.getElementById("stats-prev");
  const nextBtn = document.getElementById("stats-next");

  // Check if the elements exist before adding listeners
  if (track && prevBtn && nextBtn) {
    const slides = Array.from(track.children);
    const slideWidth = slides[0].getBoundingClientRect().width;
    let currentIndex = 0;

    // Function to move to a specific slide
    const moveToSlide = (targetIndex) => {
      track.style.transform = "translateX(-" + slideWidth * targetIndex + "px)";
      currentIndex = targetIndex;
    };

    // Event listener for the "next" button
    nextBtn.addEventListener("click", () => {
      let nextIndex = currentIndex + 1;
      // If at the end, loop back to the start
      if (nextIndex > slides.length - 2) {
        // -3 because we show 3 slides at a time
        nextIndex = 0;
      }
      moveToSlide(nextIndex);
    });

    // Event listener for the "previous" button
    prevBtn.addEventListener("click", () => {
      let prevIndex = currentIndex - 1;
      // If at the beginning, loop to the end
      if (prevIndex < 0) {
        prevIndex = slides.length - 2;
      }
      moveToSlide(prevIndex);
    });

    // Adjust slide width on window resize to keep it responsive
    window.addEventListener("resize", () => {
      const newSlideWidth = slides[0].getBoundingClientRect().width;
      track.style.transition = "none"; // Disable transition for instant resize
      track.style.transform =
        "translateX(-" + newSlideWidth * currentIndex + "px)";
      setTimeout(() => {
        track.style.transition = "transform 0.5s ease-in-out"; // Re-enable transition
      }, 50);
    });
  }
});

// Add this script just before the closing </body> tag

const projectsCarousel = new Swiper(".projects-carousel", {
  // The parallax module in Swiper works on the wrapper, not individual slides.
  // For a per-slide image parallax effect, we'd need custom JS, so this uses the parallax on the slide itself.
  speed: 800,
  parallax: true,

  // Core settings for the layout
  loop: true,

  grabCursor: true,

  // How many slides to show
  slidesPerView: "auto",
  spaceBetween: 0,

  // Navigation using the unique IDs
  navigation: {
    nextEl: "#projects-carousel-next",
    prevEl: "#projects-carousel-prev",
  },

  // We can add breakpoints for smaller screens
  breakpoints: {
    // when window width is >= 320px
    320: {
      slidesPerView: 1,
      spaceBetween: 0,
    },
    // when window width is >= 768px
    768: {
      slidesPerView: 2,
      spaceBetween: 0,
    },
    // when window width is >= 1280px
    1280: {
      slidesPerView: 3, // Shows 2 full and a part of the third
      spaceBetween: 0,
    },
  },
});

// Add this script just before the closing </body> tag

document.addEventListener("DOMContentLoaded", function () {
  // --- Part 1: On-Scroll Animation Logic ---
  const observer = new IntersectionObserver(
    (entries) => {
      entries.forEach((entry) => {
        if (entry.isIntersecting) {
          entry.target.classList.add("is-visible");
          observer.unobserve(entry.target); // Optional: stop observing once animated
        }
      });
    },
    {
      threshold: 0.1, // Trigger when 10% of the element is visible
    }
  );

  const elementsToAnimate = document.querySelectorAll(".animate-on-scroll");
  elementsToAnimate.forEach((el) => observer.observe(el));

  // --- Part 2: Modal Logic ---
  const modal = document.getElementById("feature-modal");
  const modalContent = document.getElementById("modal-content");
  const modalCloseBtn = document.getElementById("modal-close-btn");
  const readMoreBtns = document.querySelectorAll(".read-more-btn");

  // Get the elements inside the modal to populate them
  const modalIcon = document.getElementById("modal-icon");
  const modalTitle = document.getElementById("modal-title");
  const modalDescription = document.getElementById("modal-description");

  const openModal = (icon, title, description) => {
    // Populate the modal with data from the button
    modalIcon.className = icon; // Set the whole class string for Font Awesome
    modalTitle.textContent = title;
    modalDescription.textContent = description;

    // Show the modal
    document.body.classList.add("modal-open");
    modal.classList.add("is-active");
  };

  const closeModal = () => {
    document.body.classList.remove("modal-open");
    modal.classList.remove("is-active");
  };

  // Add click event to all "READ MORE" buttons
  readMoreBtns.forEach((btn) => {
    btn.addEventListener("click", function (e) {
      e.preventDefault();
      const icon = this.dataset.icon;
      const title = this.dataset.title;
      const description = this.dataset.description;
      openModal(icon, title, description);
    });
  });

  // Close modal events
  modalCloseBtn.addEventListener("click", closeModal);
  modal.addEventListener("click", (e) => {
    // Close if the dark overlay is clicked, but not the content
    if (e.target === modal) {
      closeModal();
    }
  });

  // Close modal with the Escape key
  document.addEventListener("keydown", (e) => {
    if (e.key === "Escape" && modal.classList.contains("is-active")) {
      closeModal();
    }
  });
});

// Add this script just before the closing </body> tag

document.addEventListener("DOMContentLoaded", function () {
  // --- Part 1: Animated Number Counter ---
  const statsBar = document.getElementById("stats-bar");
  const counterNumbers = document.querySelectorAll(".counter-number");
  let hasAnimated = false;

  const startCounter = (el) => {
    const target = parseInt(el.dataset.target, 10);
    let current = 0;
    const duration = 2000; // 2 seconds
    const increment = target / (duration / 16); // Calculate increment per frame (approx 60fps)

    const updateCount = () => {
      current += increment;
      if (current < target) {
        el.textContent = Math.ceil(current);
        requestAnimationFrame(updateCount);
      } else {
        el.textContent = target; // Ensure it ends on the exact target
      }
    };
    requestAnimationFrame(updateCount);
  };

  const statsObserver = new IntersectionObserver(
    (entries) => {
      entries.forEach((entry) => {
        if (entry.isIntersecting && !hasAnimated) {
          counterNumbers.forEach(startCounter);
          hasAnimated = true; // Animate only once
          statsObserver.unobserve(statsBar);
        }
      });
    },
    {
      threshold: 0.5, // Trigger when 50% of the bar is visible
    }
  );

  if (statsBar) {
    statsObserver.observe(statsBar);
  }

  // --- Part 2: Video Modal Logic ---
  const videoModal = document.getElementById("video-modal");
  const videoPlayBtn = document.getElementById("video-play-btn");
  const videoModalCloseBtn = document.getElementById("video-modal-close-btn");
  const videoIframe = document.getElementById("video-iframe");
  const videoId = "YqQxW2-Q4_4"; // IMPORTANT: Replace with your YouTube Video ID

  const openVideoModal = () => {
    videoIframe.src = `https://www.youtube.com/embed/${videoId}?autoplay=1&rel=0`;
    document.body.classList.add("modal-open");
    videoModal.classList.add("is-active");
  };

  const closeVideoModal = () => {
    videoIframe.src = ""; // This is crucial to stop the video
    document.body.classList.remove("modal-open");
    videoModal.classList.remove("is-active");
  };

  if (videoPlayBtn) {
    videoPlayBtn.addEventListener("click", openVideoModal);
  }
  if (videoModalCloseBtn) {
    videoModalCloseBtn.addEventListener("click", closeVideoModal);
  }
  if (videoModal) {
    videoModal.addEventListener("click", (e) => {
      if (e.target === videoModal) {
        closeVideoModal();
      }
    });
  }
});

// Add this script just before the closing </body> tag
document.addEventListener("DOMContentLoaded", function () {
  // Detect direction (LTR/RTL) from <html dir="">
  const isRTL = document.documentElement.getAttribute("dir") === "rtl";

  // --- 1. Testimonials Carousel ---
  const testimonialsSwiper = new Swiper(".testimonials-slider", {
    loop: true,
    grabCursor: true,
    spaceBetween: 30,
    rtl: isRTL, // enable RTL

    // Autoplay
    autoplay: {
      delay: 5000,
      disableOnInteraction: false,
    },

    // Pagination
    pagination: {
      el: ".testimonials-pagination",
      clickable: true,
    },

    // Responsive breakpoints
    breakpoints: {
      640: { slidesPerView: 1 },
      768: { slidesPerView: 2 },
      1280: { slidesPerView: 3 },
    },
  });

  // --- 2. Clients Carousel ---
  const clientsSwiper = new Swiper(".clients-slider", {
    loop: true,
    spaceBetween: 50,
    rtl: isRTL, // enable RTL

    // Autoplay
    autoplay: {
      delay: 3000,
      disableOnInteraction: false,
    },

    // Navigation arrows (they will auto-flip in RTL)
    navigation: {
      nextEl: ".clients-next",
      prevEl: ".clients-prev",
    },

    // Responsive breakpoints
    breakpoints: {
      320: { slidesPerView: 2 },
      640: { slidesPerView: 3 },
      1024: { slidesPerView: 6 },
    },
  });

  // --- 3. Creative 3D Tilt Effect for Testimonial Cards ---
  const cards = document.querySelectorAll(".testimonial-card");

  cards.forEach((card) => {
    card.addEventListener("mousemove", (e) => {
      const rect = card.getBoundingClientRect();
      const x = e.clientX - rect.left; // x position within the element.
      const y = e.clientY - rect.top; // y position within the element.

      const centerX = rect.width / 2;
      const centerY = rect.height / 2;

      const rotateX = ((y - centerY) / centerY) * -7; // Max rotation 7 degrees
      const rotateY = ((x - centerX) / centerX) * 7; // Max rotation 7 degrees

      card.style.transform = `perspective(1000px) rotateX(${rotateX}deg) rotateY(${rotateY}deg) scale3d(1.05, 1.05, 1.05)`;
    });

    card.addEventListener("mouseleave", () => {
      card.style.transform =
        "perspective(1000px) rotateX(0) rotateY(0) scale3d(1, 1, 1)";
    });
  });
});

const canvas = document.getElementById("webCanvas");
const ctx = canvas.getContext("2d");

let width, height;
let nodes = [];
let numNodes = 120;
let maxDist = 150;

// Mouse
let mouse = { x: -9999, y: -9999, radius: 120 };

// Resize + set density
function resizeCanvas() {
  width = canvas.width = window.innerWidth;
  height = canvas.height = window.innerHeight;

  // Adjust density for mobile/tablet/desktop
  if (width < 640) {
    numNodes = 50; // fewer nodes on mobile
    maxDist = 90; // shorter line distance
  } else if (width < 1024) {
    numNodes = 80; // medium nodes on tablet
    maxDist = 120;
  } else {
    numNodes = 120; // full density on desktop
    maxDist = 150;
  }

  createNodes();
}

function createNodes() {
  nodes = [];
  for (let i = 0; i < numNodes; i++) {
    nodes.push({
      x: Math.random() * width,
      y: Math.random() * height,
      vx: (Math.random() - 0.5) * 0.5,
      vy: (Math.random() - 0.5) * 0.5,
    });
  }
}

// Track mouse
window.addEventListener("mousemove", (e) => {
  mouse.x = e.clientX;
  mouse.y = e.clientY;
});
window.addEventListener("mouseleave", () => {
  mouse.x = -9999;
  mouse.y = -9999;
});

// Animation loop
function animate() {
  ctx.clearRect(0, 0, width, height);

  // Draw nodes
  nodes.forEach((n) => {
    n.x += n.vx;
    n.y += n.vy;

    if (n.x < 0 || n.x > width) n.vx *= -1;
    if (n.y < 0 || n.y > height) n.vy *= -1;

    ctx.beginPath();
    ctx.arc(n.x, n.y, 2, 0, Math.PI * 2);
    ctx.fillStyle = "rgba(220,220,220,0.6)";
    ctx.fill();
  });

  // Connect lines
  for (let i = 0; i < nodes.length; i++) {
    for (let j = i + 1; j < nodes.length; j++) {
      const dx = nodes[i].x - nodes[j].x;
      const dy = nodes[i].y - nodes[j].y;
      const dist = Math.sqrt(dx * dx + dy * dy);

      // Skip if near cursor
      const midX = (nodes[i].x + nodes[j].x) / 2;
      const midY = (nodes[i].y + nodes[j].y) / 2;
      const distMouse = Math.hypot(midX - mouse.x, midY - mouse.y);

      if (dist < maxDist && distMouse > mouse.radius) {
        ctx.beginPath();
        ctx.moveTo(nodes[i].x, nodes[i].y);
        ctx.lineTo(nodes[j].x, nodes[j].y);
        ctx.strokeStyle = `rgba(220,220,220,${1 - dist / maxDist})`;
        ctx.lineWidth = 1;
        ctx.stroke();
      }
    }
  }

  requestAnimationFrame(animate);
}

// Init
resizeCanvas();
window.addEventListener("resize", resizeCanvas);
animate();

(function () {
  const clamp = (v, min, max) => Math.max(min, Math.min(max, v));

  function getProgress(el) {
    const r = el.getBoundingClientRect();
    const vh = window.innerHeight;
    // progress = 0 when section just enters, 1 when it fully passed
    const total = r.height + vh;
    const passed = vh - r.top;
    return clamp(passed / total, 0, 1);
  }

  function setupSegment(
    segEl,
    phase,
    thickness,
    color,
    offset,
    explicitAnchor
  ) {
    const [ori, dir] = phase.split("-");
    segEl.dataset.orientation = ori; // "h" or "v"
    segEl.style.setProperty("--thickness", thickness + "px");
    segEl.style.setProperty("--color", color);

    // Reset all edges
    segEl.style.top =
      segEl.style.bottom =
      segEl.style.left =
      segEl.style.right =
        "auto";

    if (ori === "h") {
      // horizontal: place at top/bottom
      const anchor = explicitAnchor || "top";
      segEl.style[anchor] = (offset || 0) + "px";
      segEl.style.left = "0";
      segEl.style.right = "0";
      // set origin by direction
      segEl.style.transformOrigin =
        dir === "lr" ? "left center" : "right center";
      // ensure horizontal base box
      segEl.style.height = thickness + "px";
      segEl.style.width = ""; // full via left/right
    } else {
      // vertical: place at left/right
      const anchor = explicitAnchor || "right";
      segEl.style[anchor] = (offset || 0) + "px";
      segEl.style.top = "0";
      segEl.style.bottom = "0";
      // set origin by direction
      segEl.style.transformOrigin =
        dir === "tb" ? "center top" : "center bottom";
      // ensure vertical base box
      segEl.style.width = thickness + "px";
      segEl.style.height = ""; // full via top/bottom
    }
  }

  function applyProgress(segEl, phase, p) {
    const [ori] = phase.split("-");
    const scale = clamp(p, 0, 1);
    if (ori === "h") {
      segEl.style.transform = `scaleX(${scale})`;
    } else {
      segEl.style.transform = `scaleY(${scale})`;
    }
  }

  // Initialize all sections
  const sections = Array.from(document.querySelectorAll(".scroll-lines"))
    .map((sec) => {
      const seg1 = sec.querySelector('.scroll-line[data-seg="1"]');
      const seg2 = sec.querySelector('.scroll-line[data-seg="2"]');
      if (!seg1 || !seg2) return null;

      const phase1 = (sec.dataset.phase1 || "h-lr").trim(); // first segment
      const phase2 = (sec.dataset.phase2 || "v-tb").trim(); // second segment

      const thickness = parseFloat(sec.dataset.thickness || "3");
      const offset = parseFloat(sec.dataset.offset || "24");
      const color1 = sec.dataset.color1 || "#f9b233";
      const color2 = sec.dataset.color2 || "#2c3a5a";

      // optional anchors per phase (top/bottom for h, left/right for v)
      const anchor1 = sec.dataset.anchor1;
      const anchor2 = sec.dataset.anchor2;

      setupSegment(seg1, phase1, thickness, color1, offset, anchor1);
      setupSegment(seg2, phase2, thickness, color2, offset, anchor2);

      return { sec, seg1, seg2, phase1, phase2 };
    })
    .filter(Boolean);

  function render() {
    sections.forEach(({ sec, seg1, seg2, phase1, phase2 }) => {
      const prog = getProgress(sec); // 0 → 1 across the section
      // horizontal fills first half
      const p1 = clamp(prog * 3.5, 0, 1);

      // vertical fills second half
      const p2 = clamp((prog - 0.3) * 3.5, 0, 1);

      applyProgress(seg1, phase1, p1);
      applyProgress(seg2, phase2, p2);
    });
  }

  // Events
  let ticking = false;
  function onScrollResize() {
    if (!ticking) {
      requestAnimationFrame(() => {
        render();
        ticking = false;
      });
      ticking = true;
    }
  }

  document.addEventListener("DOMContentLoaded", render, { once: true });
  window.addEventListener("scroll", onScrollResize, { passive: true });
  window.addEventListener("resize", onScrollResize);
})();

document.addEventListener("DOMContentLoaded", function () {
  // --- On-Scroll Animation for History Timeline ---
  const timelineObserver = new IntersectionObserver(
    (entries) => {
      entries.forEach((entry) => {
        if (entry.isIntersecting) {
          entry.target.classList.add("is-visible");
          timelineObserver.unobserve(entry.target);
        }
      });
    },
    {
      threshold: 0.2,
    }
  );

  // We use the new unique class name to select the items
  const timelineItems = document.querySelectorAll(".history-timeline-v2__item");
  timelineItems.forEach((item) => timelineObserver.observe(item));
});
