<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    {{-- The title will be "Default Title" unless a page specifies its own --}}
    <title>@yield('title', 'Cesra Company Limited')</title>
    <!-- Font Awesome CDN for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" />
    <link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css" />
    <!-- Google Fonts for a similar look -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <!-- inside <head> -->
    <link href="https://fonts.googleapis.com/css2?family=Rubik:wght@300;400;500;600;700&display=swap"
        rel="stylesheet" />
    
    <script>
        function setDirection(dir) {
            document.documentElement.setAttribute("dir", dir);
        }
    </script>
    <!-- Our compiled Tailwind CSS -->
    <link href="{{ asset('css/app.css') }}" rel="stylesheet">
    <link type="text/css" rel="stylesheet" href="{{ asset('css/style.css') }}" />
</head>

<body class="bg-white" x-data="{ langOpen: false, currentLang: 'EN' }" class="p-10">

    {{-- 1. Include the Header --}}
    @include('partials.header')

    {{-- 2. Main Content Area --}}
    {{-- The flex-grow class makes this section expand to push the footer down --}}
    <main>
        {{-- The content from other pages will be injected here --}}
        @yield('content')
    </main>

    {{-- 3. Include the Footer --}}
    @include('partials.footer')

    <div id="video-modal"
        class="fixed inset-0 z-50 flex items-center justify-center bg-black bg-opacity-80 p-4 transition-opacity duration-300 opacity-0 pointer-events-none">
        <div
            class="bg-black w-full max-w-4xl aspect-video relative transform transition-transform duration-300 scale-95">
            <button id="video-modal-close-btn"
                class="absolute -top-4 -right-4 z-10 text-white bg-gray-800 rounded-full w-10 h-10 text-xl hover:bg-custom-yellow hover:text-black">
                &times;
            </button>
            <iframe id="video-iframe" class="w-full h-full" frameborder="0"
                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                allowfullscreen></iframe>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            // This line initializes ALL elements with the .jarallax class on the page
            jarallax(document.querySelectorAll('.jarallax'), {
                speed: 0.4 // A slightly slower speed can feel more premium
            });

            // The on-scroll animation observer
            const animatedElements = document.querySelectorAll('.animate-on-scroll');
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.classList.add('is-visible');
                    }
                });
            }, {
                threshold: 0.1
            });
            animatedElements.forEach(el => observer.observe(el));
        });
    </script>
    <!-- END: FACTS & STATS SECTION -->
    <script src="https://unpkg.com/imagesloaded@5/imagesloaded.pkgd.min.js"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/@alpinejs/collapse@3.x.x/dist/cdn.min.js"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jarallax@2/dist/jarallax.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jarallax@2/dist/jarallax-element.min.js"></script>
    <script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>
    <script src="https://unpkg.com/isotope-layout@3/dist/isotope.pkgd.min.js"></script>
    <script src="{{ asset('js/script.js') }}"></script>

</body>

</html>
