@extends('layouts.app')

@section('title', 'Our Services - Cesra Company Limited')

@section('content')
    <style>
        .glass-card {
            transform-style: preserve-3d;
            transition: transform 0.2s ease-out, box-shadow 0.2s ease-out;
            /* border-radius: 0.75rem; */
            /* rounded-xl */
            overflow: hidden;
            position: relative;
            /* The Glass Effect */
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            /* For Safari */
            border: 1px solid rgba(255, 255, 255, 0.2);
            box-shadow: 0 8px 32px 0 rgba(0, 0, 0, 0.1);
        }

        .glass-card:hover {
            box-shadow: 0 10px 40px 0 rgba(0, 0, 0, 0.2);
        }

        .glass-card-content {
            position: relative;
            padding: 2rem;
            /* 32px */
            width: 100%;
            height: 100%;
            z-index: 5;
        }

        /* Text styling for legibility on a blurred background */
        .glass-card-title {
            font-size: 1.25rem;
            /* text-xl */
            font-weight: 700;
            /* font-bold */
            color: white;
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.5);
        }

        .glass-card-text {
            color: #d1d5db;
            /* gray-300 */
            margin-top: 0.5rem;
            /* mt-2 */
            text-shadow: 0 1px 3px rgba(0, 0, 0, 0.5);
        }

        /* Background number for depth */
        .process-step-number-glass {
            position: absolute;
            right: 1rem;
            /* 16px */
            bottom: -0.5rem;
            /* -8px */
            font-size: 6rem;
            /* 96px */
            font-weight: 800;
            /* font-extrabold */
            color: rgba(255, 255, 255, 0.05);
            /* Very subtle white */
            line-height: 1;
            z-index: -1;
            user-select: none;
        }

        [dir="rtl"] .process-step-number-glass {
            right: auto;
            left: 1rem;
            /* 16px */
        }

        /* ========================================================================== */
        /*           FINAL GLASS TABS & ACCORDION STYLES (SERVICES PAGE)          */
        /* ========================================================================== */

        /* --- Base Glass Effect Styling --- */
        .glass-tab-btn,
        .glass-accordion-item,
        .glass-content-panel {
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(12px);
            -webkit-backdrop-filter: blur(12px);
            /* For Safari */
            border: 1px solid rgba(255, 255, 255, 0.15);

            /* rounded-xl */
        }

        /* --- Desktop: Vertical Glass Tabs --- */
        .glass-tab-btn {
            display: flex;
            align-items: center;
            width: 100%;
            text-align: left;
            padding: 1rem;
            /* 16px */
            font-weight: 600;
            /* font-semibold */
            color: white;
            gap: 1rem;
            /* 16px */
            transition: all 0.3s ease;
        }

        .glass-tab-btn:hover {
            background: rgba(255, 255, 255, 0.15);
            border-color: rgba(255, 255, 255, 0.25);
        }

        .glass-tab-btn.active {
            background: #e82424;
            /* custom-yellow/red */
            border-color: rgba(232, 36, 36, 0.8);
            color: white;
            box-shadow: 0 0 20px rgba(232, 36, 36, 0.3);
            /* Red glow */
        }

        .glass-tab-btn.active i {
            color: white;
        }

        .glass-tab-btn i {
            color: #e82424;
            /* custom-yellow/red */
            width: 1.5rem;
            /* 24px */
            transition: color 0.3s ease;
        }

        /* --- Mobile: Glass Accordion --- */
        .glass-accordion-item {
            box-shadow: 0 8px 32px 0 rgba(0, 0, 0, 0.1);
        }

        .glass-accordion-btn {
            display: flex;
            align-items: center;
            justify-content: space-between;
            width: 100%;
            text-align: left;
            padding: 1rem;
            /* 16px */
            font-weight: 600;
            /* font-semibold */
            color: white;
        }


        .glass-accordion-content {
            padding: 1rem 1.5rem 1.5rem 1.5rem;
            /* Tweak padding for list */
            color: #d1d5db;
            /* gray-300 */
            border-top: 1px solid rgba(255, 255, 255, 0.1);
        }

        /* --- Desktop: Main Content Panel --- */
        .glass-content-panel {
            padding: 2.5rem;
            /* 40px */
            min-height: 400px;
            /* Ensure a consistent height */
            box-shadow: 0 8px 32px 0 rgba(0, 0, 0, 0.1);
        }

        .glass-content-title {
            font-size: 2.25rem;
            /* text-4xl */
            font-weight: 800;
            /* font-extrabold */
            color: white;
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.5);
        }


        .glass-content-list-item {
            display: flex;
            align-items: flex-start;
            color: #e5e7eb;
            /* gray-200 */
            text-shadow: 0 1px 3px rgba(0, 0, 0, 0.5);
        }

        .glass-content-text {
            margin-top: 1rem;
            /* mt-4 */
            font-size: 1.125rem;
            /* text-lg */
            line-height: 1.75;
            /* leading-relaxed */
            color: #e5e7eb;
            /* gray-200 */
            text-shadow: 0 1px 3px rgba(0, 0, 0, 0.5);
        }

        /* Ensure project carousel navigation is visible against dark background */
        .bg-custom-secondary .projects-carousel__nav {
            background-color: rgba(255, 255, 255, 0.044);
            color: white;
        }

        .bg-custom-secondary .projects-carousel__nav:hover {
            background-color: #e82424;
            /* custom-yellow */
        }
    </style>
    <!-- ================== BREADCRUMB/HERO SECTION ================== -->
    <x-page-header title="Our Services"
        subtitle="Integrated EPC solutions that form the backbone of modern infrastructure and architecture in Saudi Arabia."
        image="images/slider/new/3.jpg" />
    <!-- ================== SERVICES INTRODUCTION ================== -->
    <section class="py-20 bg-white">
        <div class="container mx-auto px-4">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                <!-- Left Column: Text Content -->
                <div class="text-start animate-on-scroll">
                    <p class="text-gray-500 font-medium mb-2">Our Capabilities</p>
                    <h2 class="text-3xl sm:text-4xl md:text-5xl font-extrabold text-custom-secondary leading-tight">
                        End-to-End Solutions for Ambitious Projects
                    </h2>
                    <div class="w-16 h-1 bg-custom-yellow my-6"></div>
                    <p class="text-gray-600 leading-relaxed text-lg">
                        CESRA offers a comprehensive suite of integrated EPC services designed to manage every phase of the
                        construction process. From initial concept and engineering consultancy to flawless execution and
                        final handover, our in-house expertise ensures every project is a benchmark of quality, safety, and
                        sustainability.
                    </p>
                </div>
                <!-- Right Column: Image -->
                <div class="relative animate-on-scroll" style="animation-delay: 0.1s;">
                    <img src="images/2.png" alt="Comprehensive EPC Services"
                        class="shadow-2xl w-full h-full object-cover" />
                    <div class="absolute -bottom-4 -right-4 lg:-right-8 w-32 h-32 bg-custom-yellow/10 -z-10">
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- ================== CORE SERVICES TABS (FINAL - PARALLAX + DYNAMIC BG + GLASS) ================== -->
    <section class="relative py-20 bg-custom-secondary overflow-hidden"  x-data="{ 
             activeTab: 'infrastructure',
             tabs: {
                 // --- THIS IS THE CORRECTED PART ---
                 infrastructure: { image: '{{ asset('images/services/1.jpg') }}' },
                 construction: { image: '{{ asset('images/services/2.jpg') }}' },
                 management: { image: '{{ asset('images/services/3.jpg') }}' },
                 consultancy: { image: '{{ asset('images/services/4.jpg') }}' }
             }
         }">

        <!-- Dynamic, Multi-Layer Parallax Backgrounds -->
        <template x-for="(tab, key) in tabs" :key="key">
            <div class="jarallax absolute inset-0 z-0 transition-opacity duration-1000"
                :class="activeTab === key ? 'opacity-100' : 'opacity-0'">
                <img class="jarallax-img" :src="tab.image" :alt="key + ' background'">
            </div>
        </template>

        <!-- Dark Overlay for Readability -->
        <div class="absolute inset-0 z-10 bg-custom-secondary opacity-60"></div>

        <div class="container mx-auto px-4 relative z-20">
            <div class="text-center mb-16">
                <h2 class="text-3xl sm:text-4xl font-extrabold text-white">Explore Our Expertise</h2>
                <p class="mt-4 max-w-2xl mx-auto text-gray-200">
                    We deliver specialized solutions across critical sectors, supporting the Kingdom's growth and Vision
                    2030. Select a service to learn more.
                </p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 lg:grid-cols-4 gap-8" x-data="{ openAccordion: 'infrastructure' }">
                <!-- Left Column: Vertical Tab Buttons / Mobile Accordion -->
                <div class="md:col-span-1 lg:col-span-1">
                    <!-- Desktop View: Vertical Glass Tabs -->
                    <div class="hidden md:flex flex-col space-y-2">
                        <button @click="activeTab = 'infrastructure'" :class="{ 'active': activeTab === 'infrastructure' }"
                            class="glass-tab-btn">
                            <i class="fas fa-road w-6"></i><span>Infrastructure Works</span>
                        </button>
                        <button @click="activeTab = 'construction'" :class="{ 'active': activeTab === 'construction' }"
                            class="glass-tab-btn">
                            <i class="fas fa-hard-hat w-6"></i><span>Building Construction</span>
                        </button>
                        <button @click="activeTab = 'management'" :class="{ 'active': activeTab === 'management' }"
                            class="glass-tab-btn">
                            <i class="fas fa-tasks w-6"></i><span>Project Management</span>
                        </button>
                        <button @click="activeTab = 'consultancy'" :class="{ 'active': activeTab === 'consultancy' }"
                            class="glass-tab-btn">
                            <i class="fas fa-drafting-compass w-6"></i><span>Engineering Consultancy</span>
                        </button>
                    </div>

                    <!-- Mobile View: Glass Accordion -->
                    <!-- =================== REPLACEMENT HTML BLOCK FOR MOBILE ACCORDION =================== -->

                    <!-- Mobile View: Glass Accordion -->
                    <div class="md:hidden space-y-3">
                        <!-- Accordion Item 1: Infrastructure -->
                        <div class="glass-accordion-item">
                            <button
                                @click="openAccordion = openAccordion === 'infrastructure' ? '' : 'infrastructure'; activeTab = 'infrastructure'"
                                class="glass-accordion-btn">
                                <span><i class="fas fa-road w-6 mr-3"></i>Infrastructure Works</span>
                                <i class="fas fa-chevron-down transition-transform"
                                    :class="{ 'rotate-180': openAccordion === 'infrastructure' }"></i>
                            </button>
                            <div x-show="openAccordion === 'infrastructure'" x-collapse>
                                <div class="glass-accordion-content">
                                    <p class="mb-4">We execute essential infrastructure projects that form the backbone of
                                        urban growth, ensuring they are built to last.</p>
                                    <ul class="space-y-3 text-sm">
                                        <li class="flex items-start"><i
                                                class="fas fa-check-circle text-custom-yellow mr-3 mt-1"></i><span>Water &
                                                Sewage Networks</span></li>
                                        <li class="flex items-start"><i
                                                class="fas fa-check-circle text-custom-yellow mr-3 mt-1"></i><span>Electrical
                                                & Telecom Installations</span></li>
                                        <li class="flex items-start"><i
                                                class="fas fa-check-circle text-custom-yellow mr-3 mt-1"></i><span>Roadworks
                                                & Transportation</span></li>
                                        <li class="flex items-start"><i
                                                class="fas fa-check-circle text-custom-yellow mr-3 mt-1"></i><span>Wastewater
                                                Treatment Plants</span></li>
                                    </ul>
                                </div>
                            </div>
                        </div>

                        <!-- Accordion Item 2: Construction -->
                        <div class="glass-accordion-item">
                            <button
                                @click="openAccordion = openAccordion === 'construction' ? '' : 'construction'; activeTab = 'construction'"
                                class="glass-accordion-btn">
                                <span><i class="fas fa-hard-hat w-6 mr-3"></i>Building Construction</span>
                                <i class="fas fa-chevron-down transition-transform"
                                    :class="{ 'rotate-180': openAccordion === 'construction' }"></i>
                            </button>
                            <div x-show="openAccordion === 'construction'" x-collapse>
                                <div class="glass-accordion-content">
                                    <p class="mb-4">CESRA delivers full-scope construction for residential, commercial,
                                        governmental, and specialized buildings.</p>
                                    <ul class="space-y-3 text-sm">
                                        <li class="flex items-start"><i
                                                class="fas fa-check-circle text-custom-yellow mr-3 mt-1"></i><span>Residential
                                                Villas & Complexes</span></li>
                                        <li class="flex items-start"><i
                                                class="fas fa-check-circle text-custom-yellow mr-3 mt-1"></i><span>Commercial
                                                Showrooms & Offices</span></li>
                                        <li class="flex items-start"><i
                                                class="fas fa-check-circle text-custom-yellow mr-3 mt-1"></i><span>Governmental
                                                & Public Facilities</span></li>
                                        <li class="flex items-start"><i
                                                class="fas fa-check-circle text-custom-yellow mr-3 mt-1"></i><span>Industrial
                                                & Specialized Buildings</span></li>
                                    </ul>
                                </div>
                            </div>
                        </div>

                        <!-- Accordion Item 3: Project Management -->
                        <div class="glass-accordion-item">
                            <button
                                @click="openAccordion = openAccordion === 'management' ? '' : 'management'; activeTab = 'management'"
                                class="glass-accordion-btn">
                                <span><i class="fas fa-tasks w-6 mr-3"></i>Project Management</span>
                                <i class="fas fa-chevron-down transition-transform"
                                    :class="{ 'rotate-180': openAccordion === 'management' }"></i>
                            </button>
                            <div x-show="openAccordion === 'management'" x-collapse>
                                <div class="glass-accordion-content">
                                    <p class="mb-4">Our comprehensive oversight ensures projects are delivered on time,
                                        within budget, and to the highest quality standards.</p>
                                    <ul class="space-y-3 text-sm">
                                        <li class="flex items-start"><i
                                                class="fas fa-check-circle text-custom-yellow mr-3 mt-1"></i><span>Quality
                                                Control & Assurance</span></li>
                                        <li class="flex items-start"><i
                                                class="fas fa-check-circle text-custom-yellow mr-3 mt-1"></i><span>Budget &
                                                Schedule Management</span></li>
                                        <li class="flex items-start"><i
                                                class="fas fa-check-circle text-custom-yellow mr-3 mt-1"></i><span>Risk
                                                Assessment & Mitigation</span></li>
                                        <li class="flex items-start"><i
                                                class="fas fa-check-circle text-custom-yellow mr-3 mt-1"></i><span>Client &
                                                Stakeholder Reporting</span></li>
                                    </ul>
                                </div>
                            </div>
                        </div>

                        <!-- Accordion Item 4: Engineering Consultancy -->
                        <div class="glass-accordion-item">
                            <button
                                @click="openAccordion = openAccordion === 'consultancy' ? '' : 'consultancy'; activeTab = 'consultancy'"
                                class="glass-accordion-btn">
                                <span><i class="fas fa-drafting-compass w-6 mr-3"></i>Engineering Consultancy</span>
                                <i class="fas fa-chevron-down transition-transform"
                                    :class="{ 'rotate-180': openAccordion === 'consultancy' }"></i>
                            </button>
                            <div x-show="openAccordion === 'consultancy'" x-collapse>
                                <div class="glass-accordion-content">
                                    <p class="mb-4">We offer expert engineering services to optimize project design for
                                        performance, sustainability, and cost-effectiveness.</p>
                                    <ul class="space-y-3 text-sm">
                                        <li class="flex items-start"><i
                                                class="fas fa-check-circle text-custom-yellow mr-3 mt-1"></i><span>Technical
                                                & Feasibility Studies</span></li>
                                        <li class="flex items-start"><i
                                                class="fas fa-check-circle text-custom-yellow mr-3 mt-1"></i><span>Value
                                                Engineering Solutions</span></li>
                                        <li class="flex items-start"><i
                                                class="fas fa-check-circle text-custom-yellow mr-3 mt-1"></i><span>Sustainable
                                                & Innovative Design</span></li>
                                        <li class="flex items-start"><i
                                                class="fas fa-check-circle text-custom-yellow mr-3 mt-1"></i><span>Alignment
                                                with Global Standards</span></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- ================= END REPLACEMENT BLOCK ================= -->
                </div>

                <!-- =================== REPLACEMENT HTML BLOCK =================== -->

                <!-- Right Column: Glass Content Panel (Desktop Only) -->
                <div class="hidden md:block md:col-span-2 lg:col-span-3 glass-content-panel">

                    <!-- Infrastructure Panel -->
                    <div x-show="activeTab === 'infrastructure'" x-transition:enter="transition ease-out duration-500"
                        x-transition:enter-start="opacity-0 scale-95" x-transition:enter-end="opacity-100 scale-100">
                        <h3 class="glass-content-title">Infrastructure Works</h3>
                        <p class="glass-content-text">We execute essential infrastructure projects that form the backbone
                            of
                            urban growth. Our expertise ensures these networks are built to last, supporting communities for
                            generations.</p>
                        <ul class="mt-6 space-y-3">
                            <li class="glass-content-list-item"><i
                                    class="fas fa-check-circle text-custom-yellow mr-3"></i><span>Water & Sewage
                                    Networks</span></li>
                            <li class="glass-content-list-item"><i
                                    class="fas fa-check-circle text-custom-yellow mr-3"></i><span>Electrical & Telecom
                                    Installations</span></li>
                            <li class="glass-content-list-item"><i
                                    class="fas fa-check-circle text-custom-yellow mr-3"></i><span>Roadworks &
                                    Transportation</span></li>
                            <li class="glass-content-list-item"><i
                                    class="fas fa-check-circle text-custom-yellow mr-3"></i><span>Wastewater Treatment
                                    Plants</span></li>
                        </ul>
                    </div>

                    <!-- Construction Panel -->
                    <div x-show="activeTab === 'construction'" x-transition:enter="transition ease-out duration-500"
                        x-transition:enter-start="opacity-0 scale-95" x-transition:enter-end="opacity-100 scale-100"
                        style="display: none;">
                        <h3 class="glass-content-title">Building Construction</h3>
                        <p class="glass-content-text">CESRA delivers full-scope construction for residential, commercial,
                            governmental, and specialized buildings, including all structural, finishing, and MEP services.
                        </p>
                        <ul class="mt-6 space-y-3">
                            <li class="glass-content-list-item"><i
                                    class="fas fa-check-circle text-custom-yellow mr-3"></i><span>Residential Villas &
                                    Complexes</span></li>
                            <li class="glass-content-list-item"><i
                                    class="fas fa-check-circle text-custom-yellow mr-3"></i><span>Commercial Showrooms &
                                    Offices</span></li>
                            <li class="glass-content-list-item"><i
                                    class="fas fa-check-circle text-custom-yellow mr-3"></i><span>Governmental & Public
                                    Facilities</span></li>
                            <li class="glass-content-list-item"><i
                                    class="fas fa-check-circle text-custom-yellow mr-3"></i><span>Industrial & Specialized
                                    Buildings</span></li>
                        </ul>
                    </div>

                    <!-- Project Management Panel -->
                    <div x-show="activeTab === 'management'" x-transition:enter="transition ease-out duration-500"
                        x-transition:enter-start="opacity-0 scale-95" x-transition:enter-end="opacity-100 scale-100"
                        style="display: none;">
                        <h3 class="glass-content-title">Project Management</h3>
                        <p class="glass-content-text">Our comprehensive oversight ensures projects are delivered on time,
                            within budget, and to the highest quality standards, mitigating risks and maximizing efficiency
                            from concept to completion.</p>
                        <ul class="mt-6 space-y-3">
                            <li class="glass-content-list-item"><i
                                    class="fas fa-check-circle text-custom-yellow mr-3"></i><span>Quality Control &
                                    Assurance</span></li>
                            <li class="glass-content-list-item"><i
                                    class="fas fa-check-circle text-custom-yellow mr-3"></i><span>Budget & Schedule
                                    Management</span></li>
                            <li class="glass-content-list-item"><i
                                    class="fas fa-check-circle text-custom-yellow mr-3"></i><span>Risk Assessment &
                                    Mitigation</span></li>
                            <li class="glass-content-list-item"><i
                                    class="fas fa-check-circle text-custom-yellow mr-3"></i><span>Client & Stakeholder
                                    Reporting</span></li>
                        </ul>
                    </div>

                    <!-- Engineering Consultancy Panel -->
                    <div x-show="activeTab === 'consultancy'" x-transition:enter="transition ease-out duration-500"
                        x-transition:enter-start="opacity-0 scale-95" x-transition:enter-end="opacity-100 scale-100"
                        style="display: none;">
                        <h3 class="glass-content-title">Engineering Consultancy</h3>
                        <p class="glass-content-text">We offer expert engineering services, including technical studies and
                            value engineering solutions, to optimize project design for performance, sustainability, and
                            cost-effectiveness.</p>
                        <ul class="mt-6 space-y-3">
                            <li class="glass-content-list-item"><i
                                    class="fas fa-check-circle text-custom-yellow mr-3"></i><span>Technical & Feasibility
                                    Studies</span></li>
                            <li class="glass-content-list-item"><i
                                    class="fas fa-check-circle text-custom-yellow mr-3"></i><span>Value Engineering
                                    Solutions</span></li>
                            <li class="glass-content-list-item"><i
                                    class="fas fa-check-circle text-custom-yellow mr-3"></i><span>Sustainable & Innovative
                                    Design</span></li>
                            <li class="glass-content-list-item"><i
                                    class="fas fa-check-circle text-custom-yellow mr-3"></i><span>Alignment with Global
                                    Standards</span></li>
                        </ul>
                    </div>
                </div>

                <!-- ================= END REPLACEMENT BLOCK ================= -->
            </div>
        </div>
    </section>

    <!-- ================== THE CESRA ADVANTAGE SECTION ================== -->
    <section class="py-20 bg-white">
        <div class="container mx-auto px-4">
            <div class="text-center mb-12">
                <p class="text-gray-500 font-medium">Why Partner With Us</p>
                <h2 class="text-3xl sm:text-4xl font-extrabold text-custom-secondary">The Cesra Advantage</h2>
                <div class="w-16 h-1 bg-custom-yellow my-6 mx-auto"></div>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                <!-- Advantage 1: Safety First -->
                <div class="text-center p-6 animate-on-scroll">
                    <div class="inline-block p-5 bg-custom-yellow text-white rounded-full text-4xl">
                        <i class="fas fa-shield-alt"></i>
                    </div>
                    <h3 class="text-xl font-bold text-custom-secondary mt-4">Uncompromising Safety</h3>
                    <p class="text-gray-600 mt-2">We adhere to the strictest health, safety, and environmental standards
                        across all operations, protecting our people and your investment.</p>
                </div>
                <!-- Advantage 2: Expert Team -->
                <div class="text-center p-6 animate-on-scroll" style="animation-delay: 0.1s;">
                    <div class="inline-block p-5 bg-custom-yellow text-white rounded-full text-4xl">
                        <i class="fas fa-users-cog"></i>
                    </div>
                    <h3 class="text-xl font-bold text-custom-secondary mt-4">Integrated Expert Team</h3>
                    <p class="text-gray-600 mt-2">Our 265+ in-house engineers and technicians provide seamless
                        collaboration and expertise at every project stage.</p>
                </div>
                <!-- Advantage 3: Innovative Technology -->
                <div class="text-center p-6 animate-on-scroll" style="animation-delay: 0.2s;">
                    <div class="inline-block p-5 bg-custom-yellow text-white rounded-full text-4xl">
                        <i class="fas fa-microchip"></i>
                    </div>
                    <h3 class="text-xl font-bold text-custom-secondary mt-4">Innovative Technology</h3>
                    <p class="text-gray-600 mt-2">We leverage modern tools and value-engineered solutions to enhance
                        efficiency, reduce costs, and deliver superior results.</p>
                </div>
                <!-- Advantage 4: Vision 2030 Aligned -->
                <div class="text-center p-6 animate-on-scroll" style="animation-delay: 0.3s;">
                    <div class="inline-block p-5 bg-custom-yellow text-white rounded-full text-4xl">
                        <i class="fas fa-flag-checkered"></i>
                    </div>
                    <h3 class="text-xl font-bold text-custom-secondary mt-4">Vision 2030 Aligned</h3>
                    <p class="text-gray-600 mt-2">Our commitment to sustainable practices and landmark projects directly
                        supports the national development goals of Saudi Arabia.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- ================== OUR PROVEN PROCESS (ADVANCED 3D & PARALLAX) ================== -->
    <section class="relative py-20 bg-gray-900 overflow-hidden">
        <!-- Jarallax Parallax Background -->
        <div class="jarallax absolute inset-0 z-0">
            <img class="jarallax-img" src="images/slider/new/2.jpg" alt="Construction background">
            <!-- Dark Overlay -->
            <div class="absolute inset-0 bg-custom-secondary opacity-30"></div>
        </div>

        <div class="container mx-auto px-4 relative z-10">
            <div class="text-center mb-16">
                <p class="text-gray-300 font-medium">Our Approach to Partnership</p>
                <h2 class="text-3xl sm:text-4xl font-extrabold text-white">Our Proven Process</h2>
                <div class="w-16 h-1 bg-custom-yellow my-6 mx-auto"></div>
                <p class="mt-4 max-w-3xl mx-auto text-gray-200">
                    We follow a structured, collaborative process to ensure clarity, efficiency, and exceptional results
                    from the first conversation to the final handover.
                </p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8" x-data="card3d_handler()"
                @mousemove.throttle="on_mouse_move" @mouseleave="on_mouse_leave">

                <!-- Step 1: Discovery & Consultation -->
                <div class="glass-card animate-on-scroll process-card" :style="card_style">
                    <div class="glass-card-content">
                        <div class="process-step-number-glass">01</div>
                        <div class="text-4xl text-custom-yellow mb-4" style="text-shadow: 0 2px 4px rgba(0,0,0,0.3);"><i
                                class="fas fa-comments"></i></div>
                        <h3 class="glass-card-title">Discovery & Consultation</h3>
                        <p class="glass-card-text">We begin by listening. Our experts engage with you to understand your
                            vision, goals, and technical requirements in detail.</p>
                    </div>
                </div>

                <!-- Step 2: Engineering & Design -->
                <div class="glass-card animate-on-scroll process-card" :style="card_style"
                    style="animation-delay: 0.1s;">
                    <div class="glass-card-content">
                        <div class="process-step-number-glass">02</div>
                        <div class="text-4xl text-custom-yellow mb-4" style="text-shadow: 0 2px 4px rgba(0,0,0,0.3);"><i
                                class="fas fa-pencil-ruler"></i></div>
                        <h3 class="glass-card-title">Engineering & Design</h3>
                        <p class="glass-card-text">Our multidisciplinary team develops innovative, value-engineered plans
                            and sustainable designs tailored to your project's unique needs.</p>
                    </div>
                </div>

                <!-- Step 3: Construction & Execution -->
                <div class="glass-card animate-on-scroll process-card" :style="card_style"
                    style="animation-delay: 0.2s;">
                    <div class="glass-card-content">
                        <div class="process-step-number-glass">03</div>
                        <div class="text-4xl text-custom-yellow mb-4" style="text-shadow: 0 2px 4px rgba(0,0,0,0.3);"><i
                                class="fas fa-hard-hat"></i></div>
                        <h3 class="glass-card-title">Construction & Execution</h3>
                        <p class="glass-card-text">With a focus on safety and quality, our skilled workforce brings the
                            designs to life, managing every phase with precision and efficiency.</p>
                    </div>
                </div>

                <!-- Step 4: Handover & Support -->
                <div class="glass-card animate-on-scroll process-card" :style="card_style"
                    style="animation-delay: 0.3s;">
                    <div class="glass-card-content">
                        <div class="process-step-number-glass">04</div>
                        <div class="text-4xl text-custom-yellow mb-4" style="text-shadow: 0 2px 4px rgba(0,0,0,0.3);"><i
                                class="fas fa-key"></i></div>
                        <h3 class="glass-card-title">Handover & Support</h3>
                        <p class="glass-card-text">We ensure a seamless project completion and handover, providing 24/7
                            post-project support to guarantee long-term satisfaction.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ================== FINAL CTA SECTION ================== -->
    <section class="py-20 bg-white text-center">
        <div class="container mx-auto px-4">
            <h2 class="text-3xl sm:text-4xl font-extrabold text-custom-secondary max-w-3xl mx-auto">
                Have a Project in Mind? Let's Build It Together.
            </h2>
            <p class="mt-4 text-gray-600 max-w-2xl mx-auto">
                Our team is ready to discuss your requirements and provide a tailored solution that meets your goals.
                Contact us today for a consultation or to request a quote.
            </p>
            <a href="/contact"
                class="mt-8 inline-block bg-custom-yellow text-white px-10 py-4 hover:bg-custom-secondary font-bold transition-colors">
                Request a Quote
            </a>
        </div>
    </section>

    <script>
        // This script handles the project carousel initialization on this page.
        document.addEventListener('DOMContentLoaded', () => {
            // Initialize the main projects carousel
            const projectsSwiper = new Swiper('.projects-carousel', {
                loop: true,
                slidesPerView: 1,
                spaceBetween: 0,
                speed: 800,
                autoplay: {
                    delay: 5000,
                    disableOnInteraction: false,
                },
                navigation: {
                    nextEl: '#projects-carousel-next',
                    prevEl: '#projects-carousel-prev',
                },
                breakpoints: {
                    768: {
                        slidesPerView: 2,
                    },
                    1024: {
                        slidesPerView: 2.5, // To show a peek of the next slide
                    },
                    1280: {
                        slidesPerView: 3,
                    }
                },
            });

            // Intersection Observer for on-scroll animations
            const animatedElements = document.querySelectorAll('.animate-on-scroll');
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.classList.add('is-visible');
                    }
                });
            }, {
                threshold: 0.1
            });
            animatedElements.forEach(el => observer.observe(el));
        });
    </script>
    <script>
        // Alpine.js handler for the 3D card tilt effect
        function card3d_handler() {
            return {
                // Card's rotation and glow styles
                card_style: '',

                // This function is triggered when the mouse moves over the grid container
                on_mouse_move(event) {
                    // Get the card element the mouse is currently over
                    const card = event.target.closest('.process-card');
                    if (!card) return; // Exit if not hovering a card

                    // Get position of card element
                    const rect = card.getBoundingClientRect();
                    const absolute_x = event.clientX - rect.left;
                    const absolute_y = event.clientY - rect.top;

                    // Calculate rotation values
                    const percentage_x = 100 / rect.width * absolute_x;
                    const percentage_y = 100 / rect.height * absolute_y;
                    const rotation_x = 0.3 * (percentage_y - 50);
                    const rotation_y = -0.3 * (percentage_x - 50);

                    // Update the card style with transform and glow
                    this.card_style = `
                    transform: perspective(1000px) rotateX(${rotation_x}deg) rotateY(${rotation_y}deg) scale3d(1.05, 1.05, 1.05);
                    background-image: radial-gradient(circle at ${percentage_x}% ${percentage_y}%, rgba(255, 255, 255, 0.2), transparent);
                `;
                },

                // This function resets the card style when the mouse leaves the grid container
                on_mouse_leave() {
                    this.card_style = '';
                }
            }
        }

        document.addEventListener('DOMContentLoaded', () => {
            // Initialize Jarallax for all elements with the .jarallax class
            jarallax(document.querySelectorAll('.jarallax'), {
                speed: 0.5 // Adjust speed of parallax, 0.5 is a good starting point
            });
        });
    </script>

@endsection
