<?php

use Illuminate\Support\Facades\Route;

Route::get('/storage-link', function () {
    Artisan::call('storage:link');
    return "Storage link created successfully!";
});

Route::get('/clear-cache', function () {
    Artisan::call('cache:clear');
    Artisan::call('config:clear');
    Artisan::call('route:clear');
    Artisan::call('view:clear');
    Artisan::call('config:cache');

    return response()->json(['message' => 'All caches cleared successfully!']);
});


Route::get('/', function () {
    return view('home');
});

Route::get('/about', function () {
    return view('about');
});

Route::get('/services', function () {
    return view('services');
});

Route::get('/projects', function () {
    return view('projects');
});

Route::get('/insights', function () {
    return view('insights.index');
});

Route::get('/careers', function () {
    return view('careers.index');
});

Route::get('/insights/{slug}', function ($slug) {
    return view('insights.show');
});

Route::get('/careers/{job_slug}', function ($job_slug) {
    return view('careers.show');
});

Route::get('/contact', function () {
    return view('contact');
});


Route::get('/supplier', function () {
    return view('supplier');
});
