<?php $__env->startSection('title', 'Cesra Company Limited'); ?>

<?php $__env->startSection('content'); ?>


    <section class="hero-slider relative w-full overflow-hidden text-white">
        <div class="slide active absolute inset-0 opacity-100">
            <div class="slide-bg absolute inset-0" style="background-image: url('images/slider/new/1.jpg')"></div>
            <div class="hero-overlay w-full h-full flex items-center absolute inset-0">
                <div class="container mx-auto px-4">
                    <div class="w-full lg:w-1/2 slide-content">
                        <p
                            class="tagline text-white font-bold tracking-widest px-4 py-2 rounded-lg bg-white/10 backdrop-blur-md border border-white/20 inline-block text-stroke-white">
                            RELIABILITY | QUALITY | INNOVATION
                        </p>

                        <h1 class="title text-lg md:text-5xl font-black my-4 leading-tight">
                            WELCOME TO CESRA – ENGINEERING & CONSTRUCTION
                        </h1>
                        <p class="description text-gray-300 mb-8">
                            For more than 20 years, CESRA has been delivering end-to-end
                            contracting solutions across Saudi Arabia—building
                            residential, commercial, governmental, and infrastructure
                            projects with precision, safety, and sustainability.
                        </p>
                        <a href="#"
                            class="bg-custom-yellow text-white px-6 py-3 hover:bg-amber-500 transition-colors hidden sm:inline-block">Discover
                            Our Services</a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Slide 2 (Example) -->
        <div class="slide absolute inset-0 opacity-0">
            <div class="slide-bg absolute inset-0" style="background-image: url('images/slider/new/2.jpg')"></div>
            <div class="hero-overlay w-full h-full flex items-center absolute inset-0">
                <div class="container mx-auto px-4">
                    <div class="w-full lg:w-1/2 slide-content">
                        <p
                            class="tagline text-white font-bold tracking-widest px-4 py-2 rounded-lg bg-white/10 backdrop-blur-md border border-white/20 inline-block text-stroke-white">
                            SHAPING THE FUTURE
                        </p>

                        <h1 class="title text-lg md:text-5xl font-black my-4 leading-tight">
                            BUILDING LEGACIES WITH VISION 2030
                        </h1>
                        <p class="description text-gray-300 mb-8">
                            From mega infrastructure to specialized facilities, our
                            integrated team of 65+ engineers and 200 technicians deliver
                            projects that last—aligned with the Kingdom’s growth and
                            transformation goals.
                        </p>
                        <a href="#"
                            class="bg-custom-yellow text-white px-6 py-3 hover:bg-amber-500 transition-colors hidden sm:inline-block">Explore
                            Our Projects</a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Slider Controls -->
        <div class="absolute bottom-10 end-10 z-10">
            <div class="flex items-center space-x-2 rtl:space-x-reverse">
                <!-- Pagination Dots -->
                <div id="pagination" class="flex items-center space-x-2 rtl:space-x-reverse">
                    <!-- Dots will be generated by JS -->
                </div>

                <!-- Navigation Arrows -->
                <div class="flex">
                    <button id="prev"
                        class="w-10 h-10 bg-black bg-opacity-50 hover:bg-custom-yellow hover:text-black transition-colors">
                        <i class="fas fa-chevron-left"></i>
                    </button>
                    <button id="pause"
                        class="w-10 h-10 bg-black bg-opacity-50 hover:bg-custom-yellow hover:text-black transition-colors">
                        <i class="fas fa-pause"></i>
                    </button>
                    <button id="next"
                        class="w-10 h-10 bg-black bg-opacity-50 hover:bg-custom-yellow hover:text-black transition-colors">
                        <i class="fas fa-chevron-right"></i>
                    </button>
                </div>
            </div>
        </div>
    </section>


    <!-- What We Do Section -->
    <!-- START: WHAT WE DO SECTION -->
    <section class="scroll-lines bg-gray-50 py-20 relative overflow-hidden" data-phase1="h-lr" data-phase2="v-tb"
        data-offset="0" data-thickness="3" data-color1="#e82424" data-color2="#e82424">
        <span class="scroll-line" data-seg="1"></span>
        <span class="scroll-line" data-seg="2"></span>
        <div class="container mx-auto px-4 relative">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-16">
                <div>
                    <p class="text-custom-secondary font-medium mb-2">What We Do</p>
                    <h2
                        class="text-xl sm:text-2xl md:text-3xl lg:text-4xl xl:text-5xl font-extrabold text-custom-secondary leading-snug">
                        Delivering Integrated Construction & Infrastructure Solutions
                        Across Saudi Arabia
                    </h2>
                </div>
                <div class="text-gray-600 text-base leading-relaxed flex items-center">
                    <p>
                        CESRA is a trusted EPC contractor with 20+ years of experience and
                        projects worth over 450M SAR. From infrastructure networks to
                        iconic buildings, we provide end-to-end services with safety,
                        quality, and sustainability at the core.
                    </p>
                </div>
            </div>

            <!-- Service Cards Grid -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <!-- Card 1: Infrastructure Works -->
                <div class="flip-card-container self-start">
                    <div class="flip-card-inner">
                        <!-- FACE 1: The Front -->
                        <div class="flip-card-front bg-white p-8 shadow-lg flex flex-col">
                            <div class="absolute top-0 end-0 bg-custom-secondary text-white font-bold p-3">
                                01.
                            </div>
                            <i class="fas fa-road text-5xl text-custom-yellow mb-4"></i>

                            <div class="w-12 h-1 bg-custom-yellow mb-4"></div>
                            <h3 class="text-xl font-bold text-gray-800 mb-2">
                                Infrastructure Development
                            </h3>
                            <p class="text-gray-600 flex-grow">
                                Comprehensive design and execution of water, sewage,
                                electrical, telecom, and road networks to support Saudi
                                Arabia’s growth.
                            </p>
                            <div class="border-b-2 border-gray-200 mt-auto pt-8">
                                <div class="w-16 h-0.5 bg-custom-yellow float-right rtl:float-left"></div>
                            </div>
                        </div>

                        <!-- FACE 2: The Back -->
                        <div class="flip-card-back bg-cover bg-center p-8 shadow-lg"
                            style="
                  background-image: linear-gradient(
                      rgba(44, 58, 90, 0.6),
                      rgba(44, 58, 90, 0.6)
                    ),
                    url('images/services/1.png');
                ">
                            <div class="flex flex-col justify-center h-full text-white text-start">
                                <h3 class="text-2xl font-bold mb-3">
                                    Building Strong Foundations
                                </h3>
                                <p class="mb-6">
                                    Our infrastructure works empower communities with reliable,
                                    sustainable networks built to last.
                                </p>
                                <a href="#"
                                    class="bg-custom-yellow text-white px-6 py-3 self-start hover:bg-custom-secondary transition-colors">Read
                                    More</a>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Card 2: General Contracting -->
                <div class="flip-card-container self-start">
                    <div class="flip-card-inner">
                        <!-- FACE 1: The Front -->
                        <div class="flip-card-front bg-white p-8 shadow-lg flex flex-col">
                            <div class="absolute top-0 end-0 bg-custom-secondary text-white font-bold p-3">
                                02.
                            </div>
                            <i class="fas fa-hard-hat text-5xl text-custom-yellow mb-4"></i>
                            <div class="w-12 h-1 bg-custom-yellow mb-4"></div>
                            <h3 class="text-xl font-bold text-gray-800 mb-2">
                                General Contracting
                            </h3>
                            <p class="text-gray-600 flex-grow">
                                End-to-end EPC solutions for residential, commercial, and
                                governmental buildings—delivered with precision and safety.
                            </p>
                            <div class="border-b-2 border-gray-200 mt-auto pt-8">
                                <div class="w-16 h-0.5 bg-custom-yellow float-right rtl:float-left"></div>
                            </div>
                        </div>
                        <!-- FACE 2: The Back -->
                        <div class="flip-card-back bg-cover bg-center p-8 shadow-lg"
                            style="
                  background-image: linear-gradient(
                      rgba(44, 58, 90, 0.6),
                      rgba(44, 58, 90, 0.6)
                    ),
                    url('images/services/2.png');
                ">
                            <div class="flex flex-col justify-center h-full text-white text-start">
                                <h3 class="text-2xl font-bold mb-3">
                                    From Concept to Completion
                                </h3>
                                <p class="mb-6">
                                    We combine engineering excellence, quality materials, and
                                    skilled teams to deliver projects that exceed client
                                    expectations.
                                </p>
                                <a href="#"
                                    class="bg-custom-yellow text-white px-6 py-3 self-start hover:bg-custom-secondary transition-colors">Read
                                    More</a>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Card 3: Engineering & Consultancy -->
                <div class="flip-card-container self-start">
                    <div class="flip-card-inner">
                        <!-- FACE 1: The Front -->
                        <div class="flip-card-front bg-white p-8 shadow-lg flex flex-col">
                            <div class="absolute top-0 end-0 bg-custom-secondary text-white font-bold p-3">
                                03.
                            </div>
                            <i class="fas fa-drafting-compass text-5xl text-custom-yellow mb-4"></i>
                            <div class="w-12 h-1 bg-custom-yellow mb-4"></div>
                            <h3 class="text-xl font-bold text-gray-800 mb-2">
                                Engineering & Consultancy
                            </h3>
                            <p class="text-gray-600 flex-grow">
                                Innovative design and project management services with a focus
                                on sustainability, efficiency, and compliance with global
                                standards.
                            </p>
                            <div class="border-b-2 border-gray-200 mt-auto pt-8">
                                <div class="w-16 h-0.5 bg-custom-yellow float-right rtl:float-left"></div>
                            </div>
                        </div>
                        <!-- FACE 2: The Back -->
                        <div class="flip-card-back bg-cover bg-center p-8 shadow-lg"
                            style="
                  background-image: linear-gradient(
                      rgba(44, 58, 90, 0.6),
                      rgba(44, 58, 90, 0.6)
                    ),
                    url('images/services/3.png');
                ">
                            <div class="flex flex-col justify-center h-full text-white text-start">
                                <h3 class="text-2xl font-bold mb-3">
                                    Innovating With Purpose
                                </h3>
                                <p class="mb-6">
                                    Our consultancy team ensures every project is designed with
                                    foresight, efficiency, and alignment to Vision 2030.
                                </p>
                                <a href="#"
                                    class="bg-custom-yellow text-white px-6 py-3 self-start hover:bg-custom-secondary transition-colors">Read
                                    More</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- START: WHO WE ARE SECTION -->
    <div class="bg-white">
        <!-- Top Banner -->
        <div class="bg-custom-secondary"
            style="
          background-image: url('data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDAiIGhlaWdodD0iNDAiIHZpZXdCb3g9IjAgMCA0MCA0MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48ZyBmaWxsPSIjM2YzZjRmIiBmaWxsLW9wYWNpdHk9IjAuMyIgZmlsbC1ydWxlPSJldmVub2RkIj48cGF0aCBkPSJNOSAxOUgwdjJIODB2LTIiLz48cGF0aCBkPSJNOSAxOUgwdjJIODB2LTIiIHRyYW5zZm9ybT0icm90YXRlKDkwIDE5LjUgMTkuNSkiLz48L2c+PC9zdmc+');
        ">
            <div class="container mx-auto px-4 py-8">
                <div class="flex justify-between items-center">
                    <div class="flex items-center gap-4">
                        <div class="w-12 h-1 bg-custom-yellow hidden sm:block"></div>
                        <h3 class="text-white text-lg md:text-xl font-semibold">
                            Looking for trusted expertise in construction and
                            infrastructure?
                        </h3>
                    </div>
                    <div class="flex items-center gap-6">
                        <div class="w-1 h-12 bg-custom-yellow hidden md:block"></div>
                        <a href="#"
                            class="bg-custom-yellow text-white px-6 py-3 border border-transparent hover:border-white hover:bg-custom-secondary transition-colors whitespace-nowrap">View
                            All Services</a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Main Content Section -->
        <section class="scroll-lines py-20" data-phase1="h-rl" data-phase2="v-tb" data-anchor2="bottom" data-offset="0"
            data-thickness="3" data-color1="#e82424" data-color2="#e82424">
            <span class="scroll-line" data-seg="1"></span>
            <span class="scroll-line" data-seg="2"></span>
            <div class="container mx-auto px-4">
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-16 items-center">
                    <!-- Left Column: Text Content -->
                    <div class="text-start">
                        <p class="text-gray-500 font-medium mb-2">Our Story</p>
                        <h2
                            class="text-2xl sm:text-3xl md:text-4xl lg:text-5xl font-extrabold text-custom-secondary leading-snug">
                            Who We Are
                        </h2>

                        <div class="w-16 h-1 bg-custom-yellow my-6"></div>

                        <div class="bg-gray-100 p-6 text-gray-600 leading-relaxed">
                            Since 2005, CESRA has been a leading EPC contractor in Saudi
                            Arabia, delivering high-quality projects that shape communities
                            and support Vision 2030. We bring together engineering
                            excellence, innovative solutions, and a client-first mindset to
                            build more than projects— we build lasting legacies.
                        </div>
                        <p class="mt-6 text-gray-600 leading-relaxed">
                            With over 450M SAR worth of completed projects, our
                            multidisciplinary team of 65+ engineers and 200+ skilled
                            technicians deliver reliable, safe, and sustainable construction
                            solutions. From infrastructure networks to specialized
                            facilities, CESRA stands as a trusted partner for government,
                            private, and commercial clients across the Kingdom.
                        </p>
                        <a href="#"
                            class="mt-8 inline-block bg-custom-secondary text-white px-8 py-4 hover:bg-black transition-colors">READ
                            MORE ABOUT US</a>
                    </div>

                    <!-- Right Column: Image and Stats Slider -->
                    <div class="relative">
                        <!-- Decorative Frame -->
                        <div class="absolute -top-6 -start-6 lg:-start-12 bottom-12 end-12 rounded-sm"></div>

                        <!-- Image + Stats -->
                        <div class="relative z-10 shadow-2xl">
                            <div class="overflow-hidden">
                                <img src="images/6.jpg" alt="CESRA team working on major infrastructure project"
                                    class="w-full h-full object-cover kenburns-image" />
                            </div>

                            <!-- CESRA Branding -->
                            <div
                                class="absolute top-12 -end-24 z-20 bg-custom-yellow text-white px-8 py-3 tracking-[0.4em] hidden xl:block">
                                C E S R A
                            </div>

                            <!-- Stats Slider -->
                            <div class="bg-custom-secondary text-white p-6 flex justify-between items-center">
                                <div class="flex-grow overflow-hidden">
                                    <div id="stats-track" class="flex transition-transform duration-500 ease-in-out">
                                        <!-- Cranes -->
                                        <div class="w-1/3 flex-shrink-0 text-center px-2">
                                            <p class="text-2xl sm:text-3xl md:text-4xl font-bold">
                                                25+
                                            </p>
                                            <p class="text-xs sm:text-sm text-custom-yellow tracking-widest">
                                                LIFTING CRANES
                                            </p>
                                        </div>

                                        <!-- Excavators -->
                                        <div class="w-1/3 flex-shrink-0 text-center px-2 border-x border-gray-600">
                                            <p class="text-2xl sm:text-3xl md:text-4xl font-bold">
                                                30+
                                            </p>
                                            <p class="text-xs sm:text-sm text-custom-yellow tracking-widest">
                                                EXCAVATORS
                                            </p>
                                        </div>

                                        <!-- Trucks -->
                                        <div class="w-1/3 flex-shrink-0 text-center px-2">
                                            <p class="text-2xl sm:text-3xl md:text-4xl font-bold">
                                                40+
                                            </p>
                                            <p class="text-xs sm:text-sm text-custom-yellow tracking-widest">
                                                HEAVY TRUCKS
                                            </p>
                                        </div>

                                        <!-- Generators -->
                                        <div class="w-1/3 flex-shrink-0 text-center px-2 border-s border-gray-600">
                                            <p class="text-2xl sm:text-3xl md:text-4xl font-bold">
                                                20+
                                            </p>
                                            <p class="text-xs sm:text-sm text-custom-yellow tracking-widest">
                                                GENERATORS
                                            </p>
                                        </div>

                                        <!-- Prefab Units -->
                                        <div class="w-1/3 flex-shrink-0 text-center px-2 border-s border-gray-600">
                                            <p class="text-2xl sm:text-3xl md:text-4xl font-bold">
                                                15+
                                            </p>
                                            <p class="text-xs sm:text-sm text-custom-yellow tracking-widest">
                                                PREFAB UNITS
                                            </p>
                                        </div>
                                    </div>
                                </div>

                                <!-- Slider Navigation -->
                                <div class="flex items-center ps-4">
                                    <div class="w-px h-12 bg-gray-600"></div>
                                    <div class="flex flex-col gap-4 px-4">
                                        <button id="stats-prev"
                                            class="text-gray-500 hover:text-custom-yellow transition-colors">
                                            <i class="fas fa-chevron-up"></i>
                                        </button>
                                        <button id="stats-next"
                                            class="text-gray-500 hover:text-custom-yellow transition-colors">
                                            <i class="fas fa-chevron-down"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>


        <section class="w-full bg-custom-secondary text-white relative overflow-hidden" dir="ltr">
            <div class="px-0 flex flex-col lg:flex-row flex-wrap lg:flex-nowrap relative">
                <!-- Left Column -->
                <div id="webSection"
                    class="w-full md:w-2/5 xl:w-1/3 flex-shrink-0 py-10 lg:py-32 z-10 px-4 sm:px-12 lg:pe-12">
                    <canvas id="webCanvas" class="absolute inset-0 w-full pointer-events-none"></canvas>
                    <div class="relative z-10">
                        <div class="w-12 h-1 bg-custom-yellow mb-4"></div>
                        <h2
                            class="text-2xl sm:text-3xl md:text-4xl lg:text-5xl font-extrabold leading-snug section-heading">
                            Our Latest Projects
                        </h2>
                        <p class="mt-6 text-gray-400 leading-relaxed section-text">
                            CESRA has proudly delivered landmark infrastructure,
                            residential, and governmental projects across Saudi Arabia. Each
                            project reflects our commitment to safety, quality, and
                            sustainable growth in line with Vision 2030.
                        </p>
                        <a href="#"
                            class="mt-6 inline-block bg-custom-yellow text-white px-8 py-2 border border-transparent hover:border-white hover:bg-custom-secondary transition duration-300 transition-colors">
                            View All Projects
                        </a>
                    </div>
                </div>

                <!-- Right Column -->
                <div class="w-full md:w-3/5 xl:w-2/3 relative lg:static lg:h-auto z-50">
                    <div class="relative h-full">
                        <div class="swiper projects-carousel h-full">
                            <div class="swiper-wrapper items-center">
                                <!-- Slide 1 -->
                                <div class="swiper-slide projects-carousel__slide">
                                    <div class="projects-carousel__image"
                                        style="background-image:url('images/project/1.jpg')" data-swiper-parallax="-25%">
                                    </div>
                                    <div class="projects-carousel__content slide-text">
                                        <h3>National Water Network</h3>
                                        <p>
                                            Large-scale water and sewage infrastructure ensuring reliable services for
                                            communities.
                                        </p>
                                    </div>
                                    <div class="projects-carousel__tag">01.</div>
                                </div>

                                <!-- Slide 2 -->
                                <div class="swiper-slide projects-carousel__slide">
                                    <div class="projects-carousel__image"
                                        style="background-image:url('images/project/2.jpg')" data-swiper-parallax="-25%">
                                    </div>
                                    <div class="projects-carousel__content slide-text">
                                        <h3>Governmental Facilities</h3>
                                        <p>
                                            Modern, efficient buildings supporting public services and national growth.
                                        </p>
                                    </div>
                                    <div class="projects-carousel__tag">02.</div>
                                    <div class="projects-carousel__category">CIVIL CONSTRUCTION</div>
                                </div>

                                <!-- Slide 3 -->
                                <div class="swiper-slide projects-carousel__slide">
                                    <div class="projects-carousel__image"
                                        style="background-image:url('images/project/1.jpg')" data-swiper-parallax="-25%">
                                    </div>
                                    <div class="projects-carousel__content slide-text">
                                        <h3>Commercial Complexes</h3>
                                        <p>
                                            Innovative retail and office spaces built with precision and sustainability.
                                        </p>
                                    </div>
                                    <div class="projects-carousel__tag">03.</div>
                                    <div class="projects-carousel__category">COMMERCIAL</div>
                                </div>

                                <!-- Slide 4 -->
                                <div class="swiper-slide projects-carousel__slide">
                                    <div class="projects-carousel__image"
                                        style="background-image:url('images/project/2.jpg')" data-swiper-parallax="-25%">
                                    </div>
                                    <div class="projects-carousel__content slide-text">
                                        <h3>Fuel Stations Network</h3>
                                        <p>
                                            State-of-the-art fueling facilities with integrated safety and service systems.
                                        </p>
                                    </div>
                                    <div class="projects-carousel__tag">04.</div>
                                </div>

                                <!-- Slide 5 -->
                                <div class="swiper-slide projects-carousel__slide">
                                    <div class="projects-carousel__image"
                                        style="background-image:url('images/project/1.jpg')" data-swiper-parallax="-25%">
                                    </div>
                                    <div class="projects-carousel__content slide-text">
                                        <h3>Sports & Leisure Facilities</h3>
                                        <p>
                                            Modern venues designed to inspire communities and support active lifestyles.
                                        </p>
                                    </div>
                                    <div class="projects-carousel__tag">05.</div>
                                </div>

                                <!-- Slide 6 -->
                                <div class="swiper-slide projects-carousel__slide">
                                    <div class="projects-carousel__image"
                                        style="background-image:url('images/project/2.jpg')" data-swiper-parallax="-25%">
                                    </div>
                                    <div class="projects-carousel__content slide-text">
                                        <h3>Banking & Corporate Offices</h3>
                                        <p>
                                            Secure and efficient facilities for leading financial and corporate
                                            institutions.
                                        </p>
                                    </div>
                                    <div class="projects-carousel__tag">06.</div>
                                </div>
                            </div>
                        </div>

                        <!-- Navigation -->
                        <div id="projects-carousel-prev" class="projects-carousel__nav projects-carousel__nav--prev">
                            <i class="fas fa-chevron-left"></i>
                        </div>
                        <div id="projects-carousel-next" class="projects-carousel__nav projects-carousel__nav--next">
                            <i class="fas fa-chevron-right"></i>
                        </div>
                    </div>
                </div>
            </div>
        </section>


        <!-- START: WHY CHOOSE US SECTION -->
        <section id="why-choose-us" class="bg-gray-50 py-20 scroll-lines relative overflow-hidden" data-phase1="h-lr"
            data-phase2="v-tb" data-offset="0" data-thickness="3" data-color1="#e82424" data-color2="#e82424"
            style="
        background-image: url('data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxMDAiIGhlaWdodD0iMTAwIj48cGF0aCBkPSJNNTAsMS45TDEwLDI2LjVWNzUuNUw1MCw5OS4xTDkwLDc1LjVW chunky chunky chunky chunky chunkyMjYuNVoiIGZpbGw9Im5vbmUiIHN0cm9rZT0iI2YwZjBmMCIgc3Ryb2tlLXdpZHRoPSIxIi8+PC9zdmc+');
        background-repeat: repeat;
      ">
            <span class="scroll-line" data-seg="1"></span>
            <span class="scroll-line" data-seg="2"></span>
            <div class="container mx-auto px-4">
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-16 items-center">
                    <!-- Left Column: Text Content -->
                    <div class="text-start animate-on-scroll">
                        <p class="text-gray-500 font-medium mb-2">
                            Trusted by Leading Clients
                        </p>
                        <h2
                            class="text-2xl sm:text-3xl md:text-4xl lg:text-5xl font-extrabold text-custom-secondary leading-snug tracking-tight">
                            WHY CHOOSE US
                        </h2>

                        <div class="w-16 h-1 bg-custom-yellow my-6"></div>
                        <p class="text-gray-600 leading-relaxed">
                            CESRA stands apart as one of Saudi Arabia’s most reliable EPC
                            contractors. With 20+ years of experience, 450M SAR worth of
                            completed projects, and a highly skilled workforce, we deliver
                            innovative, sustainable, and cost-effective solutions tailored to
                            every client’s needs.
                        </p>
                        <div class="w-full h-px bg-gray-200 mt-8">
                            <div class="w-16 h-0.5 bg-custom-yellow float-left rtl:float-right"></div>
                        </div>
                    </div>

                    <!-- Right Column: Feature Cards -->
                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-8">
                        <!-- Card 1: Sustainability -->
                        <div
                            class="relative bg-white p-6 shadow-md transition-all duration-300 hover:shadow-2xl hover:-translate-y-2 animate-on-scroll">
                            <div class="flex items-start gap-4">
                                <div
                                    class="flex-shrink-0 bg-custom-yellow text-white w-14 h-14 flex items-center justify-center">
                                    <i class="fas fa-leaf text-2xl"></i>
                                </div>
                                <div>
                                    <h3 class="text-xl font-bold text-custom-secondary">
                                        Commitment to Sustainability
                                    </h3>
                                    <p class="text-gray-600 mt-2 text-sm">
                                        We integrate eco-friendly methods and sustainable practices
                                        in all our projects.
                                    </p>
                                    <a href="#"
                                        class="read-more-btn mt-4 inline-block font-bold text-gray-800 text-sm tracking-wider border-b-2 border-transparent hover:border-custom-yellow transition-colors"
                                        data-icon="fas fa-leaf" data-title="Sustainable Solutions"
                                        data-description="Aligned with Vision 2030, CESRA focuses on building greener infrastructure and facilities that minimize environmental impact while ensuring long-term efficiency and value.">
                                        READ MORE
                                    </a>
                                </div>
                            </div>
                            <div class="absolute top-4 right-4 text-gray-300 font-bold">
                                01.
                            </div>
                        </div>

                        <!-- Card 2: Technology -->
                        <div class="relative bg-white p-6 shadow-md transition-all duration-300 hover:shadow-2xl hover:-translate-y-2 animate-on-scroll"
                            style="animation-delay: 0.1s">
                            <div class="flex items-start gap-4">
                                <div
                                    class="flex-shrink-0 bg-custom-yellow text-white w-14 h-14 flex items-center justify-center">
                                    <i class="fas fa-microchip text-2xl"></i>
                                </div>
                                <div>
                                    <h3 class="text-xl font-bold text-custom-secondary">
                                        Innovative Technology
                                    </h3>
                                    <p class="text-gray-600 mt-2 text-sm">
                                        We adopt modern tools and digital solutions for efficient
                                        project delivery.
                                    </p>
                                    <a href="#"
                                        class="read-more-btn mt-4 inline-block font-bold text-gray-800 text-sm tracking-wider border-b-2 border-transparent hover:border-custom-yellow transition-colors"
                                        data-icon="fas fa-microchip" data-title="Advanced Engineering"
                                        data-description="From Building Information Modeling (BIM) to advanced project management platforms, CESRA ensures precise planning, faster execution, and superior outcomes.">
                                        READ MORE
                                    </a>
                                </div>
                            </div>
                            <div class="absolute top-4 right-4 text-gray-300 font-bold">
                                02.
                            </div>
                        </div>

                        <!-- Card 3: Quality & Safety -->
                        <div class="relative bg-white p-6 shadow-md transition-all duration-300 hover:shadow-2xl hover:-translate-y-2 animate-on-scroll"
                            style="animation-delay: 0.2s">
                            <div class="flex items-start gap-4">
                                <div
                                    class="flex-shrink-0 bg-custom-yellow text-white w-14 h-14 flex items-center justify-center">
                                    <i class="fas fa-tools text-2xl"></i>
                                </div>
                                <div>
                                    <h3 class="text-xl font-bold text-custom-secondary">
                                        Quality & Safety First
                                    </h3>
                                    <p class="text-gray-600 mt-2 text-sm">
                                        We maintain the highest standards of quality assurance and
                                        HSE compliance.
                                    </p>
                                    <a href="#"
                                        class="read-more-btn mt-4 inline-block font-bold text-gray-800 text-sm tracking-wider border-b-2 border-transparent hover:border-custom-yellow transition-colors"
                                        data-icon="fas fa-tools" data-title="Safe & Reliable Execution"
                                        data-description="Every project is backed by rigorous safety protocols and quality checks, protecting people and ensuring long-lasting results.">
                                        READ MORE
                                    </a>
                                </div>
                            </div>
                            <div class="absolute top-4 right-4 text-gray-300 font-bold">
                                03.
                            </div>
                        </div>

                        <!-- Card 4: Expert Team -->
                        <div class="relative bg-white p-6 shadow-md transition-all duration-300 hover:shadow-2xl hover:-translate-y-2 animate-on-scroll"
                            style="animation-delay: 0.3s">
                            <div class="flex items-start gap-4">
                                <div
                                    class="flex-shrink-0 bg-custom-yellow text-white w-14 h-14 flex items-center justify-center">
                                    <i class="fas fa-hard-hat text-2xl"></i>
                                </div>
                                <div>
                                    <h3 class="text-xl font-bold text-custom-secondary">
                                        Skilled & Dedicated Team
                                    </h3>
                                    <p class="text-gray-600 mt-2 text-sm">
                                        65+ engineers and 200+ technicians deliver expertise and
                                        precision at every stage.
                                    </p>
                                    <a href="#"
                                        class="read-more-btn mt-4 inline-block font-bold text-gray-800 text-sm tracking-wider border-b-2 border-transparent hover:border-custom-yellow transition-colors"
                                        data-icon="fas fa-hard-hat" data-title="Our People"
                                        data-description="Our greatest strength lies in our people. With multidisciplinary skills and a client-first approach, CESRA’s team ensures excellence from concept to completion.">
                                        READ MORE
                                    </a>
                                </div>
                            </div>
                            <div class="absolute top-4 right-4 text-gray-300 font-bold">
                                04.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Modal Structure (Hidden by default) -->
        <div id="feature-modal"
            class="fixed inset-0 z-50 flex items-center justify-center bg-custom-secondary bg-opacity-70 p-4 transition-opacity duration-300 opacity-0 pointer-events-none">
            <div id="modal-content"
                class="bg-white shadow-2xl w-full max-w-2xl transform transition-transform duration-300 scale-95">
                <!-- Modal Header -->
                <div class="flex justify-between items-center p-6 border-b">
                    <div class="flex items-center gap-4">
                        <div id="modal-icon-container"
                            class="bg-custom-yellow text-white w-12 h-12 flex items-center justify-center rounded-md text-2xl">
                            <i id="modal-icon" class=""></i>
                        </div>
                        <h3 id="modal-title" class="text-2xl font-bold text-gray-800">
                            Modal Title
                        </h3>
                    </div>
                    <button id="modal-close-btn" class="text-gray-400 hover:text-gray-800 text-2xl">
                        &times;
                    </button>
                </div>
                <!-- Modal Body -->
                <div class="p-6">
                    <p id="modal-description" class="text-gray-600 leading-relaxed">
                        Modal description goes here...
                    </p>
                </div>
            </div>
        </div>
        <!-- END: WHY CHOOSE US SECTION -->

        <!-- START: FACTS & STATS SECTION -->
        <section class="relative bg-custom-secondary text-white pt-20">
            <!-- Background Image & Overlay -->
            <div class="absolute inset-0 z-0">
                <img src="images/slider/3.jpg" alt="CESRA crane at a construction site"
                    class="w-full h-full object-cover opacity-30" />
                <div class="absolute inset-0 bg-gradient-to-t from-gray-900 via-gray-900/80 to-transparent"></div>
            </div>

            <div class="container mx-auto px-4 relative z-10">
                <!-- Top Header Content -->
                <div class="flex flex-col md:flex-row justify-between items-start md:items-end gap-8 pb-32">
                    <div class="w-full md:w-1/2">
                        <p class="text-custom-yellow font-semibold">Some Facts About Us</p>
                        <h2 class="text-2xl sm:text-3xl md:text-4xl lg:text-5xl font-extrabold mt-2 leading-tight">
                            Setting New Standards in EPC Contracting Excellence Worldwide
                        </h2>
                    </div>

                    <div class="w-full md:w-1/3 text-gray-300 leading-relaxed paragraph-line-hover">
                        <p>
                            With over two decades of experience, CESRA has delivered projects
                            worth more than 450M SAR across Saudi Arabia. Our portfolio spans
                            infrastructure, residential, commercial, and governmental
                            facilities— each built with precision, safety, and sustainability
                            at the core.
                        </p>
                    </div>
                </div>

                <!-- Overlapping Content Block -->
                <div class="relative -mt-24 z-20">
                    <div class="grid grid-cols-1 lg:grid-cols-2 shadow-2xl">
                        <!-- Left Yellow Box -->
                        <div class="bg-custom-yellow text-white p-8 md:p-12 relative overflow-hidden">
                            <p class="font-semibold tracking-wider">MORE ABOUT US</p>
                            <h3 class="text-xl sm:text-2xl md:text-3xl lg:text-4xl font-extrabold mt-4 leading-snug">
                                20+ years of engineering excellence in Saudi Arabia
                            </h3>

                            <p class="mt-4 text-white leading-relaxed">
                                Since 2005, CESRA has been a trusted partner for some of the
                                Kingdom’s most complex and high-value projects. Our commitment
                                to quality, innovation, and client satisfaction makes us a
                                leading name in EPC contracting, aligned with Vision 2030.
                            </p>
                            <a href="#"
                                class="mt-8 inline-block bg-custom-secondary text-white px-8 py-3 hover:bg-custom-yellow border border-transparent hover:border-white transition-colors">REQUEST
                                A QUOTE</a>
                            <!-- Faint background icon -->
                            <i
                                class="fas fa-building absolute bottom-4 right-4 text-custom-yellow/20 text-8xl -rotate-12 pointer-events-none"></i>
                        </div>

                        <!-- Right Image/Video Box -->
                        <div class="relative min-h-[400px]">
                            <img src="images/slider/2.jpg" class="absolute w-full h-full object-cover"
                                alt="CESRA construction team at work" />
                            <div id="video-play-btn"
                                class="absolute inset-0 flex flex-col items-center justify-center bg-black/40 cursor-pointer group">
                                <div
                                    class="w-20 h-20 bg-custom-yellow/80 rounded-full flex items-center justify-center text-white text-3xl transition-transform duration-300 group-hover:scale-110 video-play-button">
                                    <i class="fas fa-play"></i>
                                </div>
                                <p class="mt-4 font-semibold tracking-widest text-white">
                                    VIDEO ABOUT OUR COMPANY
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Stats Bar -->
            <div id="stats-bar" class="bg-custom-secondary relative z-10">
                <div class="container mx-auto px-4">
                    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4">
                        <!-- Stat 1 -->
                        <div class="p-8 text-center">
                            <p class="text-2xl sm:text-3xl md:text-4xl lg:text-5xl font-bold">
                                <span class="text-custom-yellow text-lg sm:text-xl md:text-2xl lg:text-3xl me-2">+</span>
                                <span class="counter-number" data-target="450">0</span>M
                            </p>
                            <p class="text-xs sm:text-sm text-gray-400 tracking-widest mt-2">
                                SAR PROJECTS DELIVERED
                            </p>
                        </div>

                        <!-- Stat 2 -->
                        <div class="p-8 text-center sm:border-s border-gray-700">
                            <p class="text-2xl sm:text-3xl md:text-4xl lg:text-5xl font-bold">
                                <span class="text-custom-yellow text-lg sm:text-xl md:text-2xl lg:text-3xl me-2">+</span>
                                <span class="counter-number" data-target="200">0</span>
                            </p>
                            <p class="text-xs sm:text-sm text-gray-400 tracking-widest mt-2">
                                SKILLED TECHNICIANS
                            </p>
                        </div>

                        <!-- Stat 3 -->
                        <div class="p-8 text-center lg:border-s border-gray-700">
                            <p class="text-2xl sm:text-3xl md:text-4xl lg:text-5xl font-bold">
                                <span class="text-custom-yellow text-lg sm:text-xl md:text-2xl lg:text-3xl me-2">+</span>
                                <span class="counter-number" data-target="65">0</span>
                            </p>
                            <p class="text-xs sm:text-sm text-gray-400 tracking-widest mt-2">
                                ENGINEERS & SPECIALISTS
                            </p>
                        </div>

                        <!-- Stat 4 -->
                        <div class="p-8 text-center sm:border-s border-gray-700">
                            <p class="text-2xl sm:text-3xl md:text-4xl lg:text-5xl font-bold">
                                <span class="text-custom-yellow text-lg sm:text-xl md:text-2xl lg:text-3xl me-2">+</span>
                                <span class="counter-number" data-target="20">0</span>
                            </p>
                            <p class="text-xs sm:text-sm text-gray-400 tracking-widest mt-2">
                                YEARS OF EXPERIENCE
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- START: TESTIMONIALS & CLIENTS SECTION -->
        <!-- ================== TESTIMONIALS SECTION ================== -->
        <section class="bg-gray-50 relative py-20 w-full scroll-lines relative overflow-hidden" data-phase1="h-rl"
            data-phase2="v-tb" data-anchor2="bottom" data-offset="0" data-thickness="3" data-color1="#e82424"
            data-color2="#e82424" id="testimonialsSection">
            <span class="scroll-line" data-seg="1"></span>
            <span class="scroll-line" data-seg="2"></span>
            <div class="container mx-auto px-4 text-center">
                <p class="text-gray-500 font-medium">Our Clients Say</p>
                <h2 class="text-2xl sm:text-3xl md:text-4xl lg:text-5xl font-extrabold text-gray-800 mt-2 leading-snug">
                    CUSTOMER REVIEWS
                </h2>

                <div class="w-16 h-1 bg-custom-yellow my-6 mx-auto"></div>

                <!-- Testimonials Carousel -->
                <div class="swiper testimonials-slider py-8">
                    <div class="swiper-wrapper">
                        <!-- Slide 1 -->
                        <div class="swiper-slide">
                            <div class="testimonial-card">
                                <div class="testimonial-card__header">
                                    <img src="images/profile/2.jpg" alt="Client Review"
                                        class="w-16 h-16 rounded-full object-cover" />
                                    <div>
                                        <h4 class="font-bold text-gray-800">
                                            Eng. Abdulrahman Al-Qahtani
                                        </h4>
                                        <p class="text-sm text-gray-500">
                                            Government Sector Client
                                        </p>
                                        <div class="text-custom-yellow mt-1">
                                            <i class="fas fa-star"></i><i class="fas fa-star"></i><i
                                                class="fas fa-star"></i><i class="fas fa-star"></i><i
                                                class="fas fa-star"></i>
                                        </div>
                                    </div>
                                </div>
                                <p class="testimonial-card__body">
                                    "CESRA successfully delivered our infrastructure project ahead
                                    of schedule without compromising quality or safety. Their
                                    team’s professionalism and attention to detail exceeded our
                                    expectations."
                                </p>
                                <div class="testimonial-card__quote-bg">
                                    <i class="fas fa-quote-right"></i>
                                </div>
                                <div class="testimonial-card__number">01.</div>
                            </div>
                        </div>
                        <!-- Slide 2 -->
                        <div class="swiper-slide">
                            <div class="testimonial-card">
                                <div class="testimonial-card__header">
                                    <img src="images/profile/3.jpg" alt="Client Review"
                                        class="w-16 h-16 rounded-full object-cover" />
                                    <div>
                                        <h4 class="font-bold text-gray-800">Sarah Mitchell</h4>
                                        <p class="text-sm text-gray-500">Corporate Client</p>
                                        <div class="text-custom-yellow mt-1">
                                            <i class="fas fa-star"></i><i class="fas fa-star"></i><i
                                                class="fas fa-star"></i><i class="fas fa-star"></i><i
                                                class="fas fa-star"></i>
                                        </div>
                                    </div>
                                </div>
                                <p class="testimonial-card__body">
                                    "From design to handover, CESRA provided a seamless
                                    experience. Their innovative solutions and transparent
                                    communication made them our contractor of choice for multiple
                                    projects."
                                </p>
                                <div class="testimonial-card__quote-bg">
                                    <i class="fas fa-quote-right"></i>
                                </div>
                                <div class="testimonial-card__number text-custom-yellow">
                                    02.
                                </div>
                            </div>
                        </div>
                        <!-- Slide 3 -->
                        <div class="swiper-slide">
                            <div class="testimonial-card">
                                <div class="testimonial-card__header">
                                    <img src="images/profile/2.jpg" alt="Client Review"
                                        class="w-16 h-16 rounded-full object-cover" />
                                    <div>
                                        <h4 class="font-bold text-gray-800">Mohammed Al-Fahad</h4>
                                        <p class="text-sm text-gray-500">Real Estate Developer</p>
                                        <div class="text-custom-yellow mt-1">
                                            <i class="fas fa-star"></i><i class="fas fa-star"></i><i
                                                class="fas fa-star"></i><i class="fas fa-star"></i><i
                                                class="fas fa-star-half-alt"></i>
                                        </div>
                                    </div>
                                </div>
                                <p class="testimonial-card__body">
                                    "Their ability to manage complex engineering challenges and
                                    deliver sustainable building solutions makes CESRA stand out
                                    in the market. We are proud to have partnered with them."
                                </p>
                                <div class="testimonial-card__quote-bg">
                                    <i class="fas fa-quote-right"></i>
                                </div>
                                <div class="testimonial-card__number">03.</div>
                            </div>
                        </div>
                        <!-- Slide 4 -->
                        <div class="swiper-slide">
                            <div class="testimonial-card">
                                <div class="testimonial-card__header">
                                    <img src="images/profile/3.jpg" alt="Client Review"
                                        class="w-16 h-16 rounded-full object-cover" />
                                    <div>
                                        <h4 class="font-bold text-gray-800">Aisha Khan</h4>
                                        <p class="text-sm text-gray-500">Private Client</p>
                                        <div class="text-custom-yellow mt-1">
                                            <i class="fas fa-star"></i><i class="fas fa-star"></i><i
                                                class="fas fa-star"></i><i class="fas fa-star"></i><i
                                                class="fas fa-star"></i>
                                        </div>
                                    </div>
                                </div>
                                <p class="testimonial-card__body">
                                    "CESRA handled our residential construction with utmost care
                                    and precision. The result was a modern, sustainable home built
                                    on time and within budget."
                                </p>
                                <div class="testimonial-card__quote-bg">
                                    <i class="fas fa-quote-right"></i>
                                </div>
                                <div class="testimonial-card__number">04.</div>
                            </div>
                        </div>
                    </div>
                    <!-- Testimonials Pagination -->
                    <div class="swiper-pagination testimonials-pagination"></div>
                </div>
            </div>
        </section>

        <!-- ================== CLIENTS SECTION ================== -->
        <section class="bg-white py-16 border-t border-gray-200" id="clientsSection">

            <div class="container mx-auto px-4">
                <div class="swiper clients-slider">
                    <div class="swiper-wrapper">
                        <div class="swiper-slide">
                            <img src="images/clients/1.jpg" alt="Client 1"
                                class="h-32 mx-auto filter grayscale hover:grayscale-0 hover:opacity-100 transition-all duration-300" />
                        </div>
                        <div class="swiper-slide">
                            <img src="images/clients/2.jpg" alt="Client 2"
                                class="h-32 mx-auto filter grayscale hover:grayscale-0 hover:opacity-100 transition-all duration-300" />
                        </div>
                        <div class="swiper-slide">
                            <img src="images/clients/3.jpg" alt="Client 3"
                                class="h-32 mx-auto filter grayscale hover:grayscale-0 hover:opacity-100 transition-all duration-300" />
                        </div>
                        <div class="swiper-slide">
                            <img src="images/clients/4.jpg" alt="Client 4"
                                class="h-32 mx-auto filter grayscale hover:grayscale-0 hover:opacity-100 transition-all duration-300" />
                        </div>
                        <div class="swiper-slide">
                            <img src="images/clients/5.jpg" alt="Client 5"
                                class="h-32 mx-auto filter grayscale hover:grayscale-0 hover:opacity-100 transition-all duration-300" />
                        </div>
                        <div class="swiper-slide">
                            <img src="images/clients/6.jpg" alt="Client 6"
                                class="h-32 mx-auto filter grayscale hover:grayscale-0 hover:opacity-100 transition-all duration-300" />
                        </div>
                        <div class="swiper-slide">
                            <img src="images/clients/7.jpg" alt="Client 6"
                                class="h-32 mx-auto filter grayscale hover:grayscale-0 hover:opacity-100 transition-all duration-300" />
                        </div>
                        <div class="swiper-slide">
                            <img src="images/clients/8.jpg" alt="Client 6"
                                class="h-32 mx-auto filter grayscale hover:grayscale-0 hover:opacity-100 transition-all duration-300" />
                        </div>
                        <div class="swiper-slide">
                            <img src="images/clients/9.jpg" alt="Client 6"
                                class="h-32 mx-auto filter grayscale hover:grayscale-0 hover:opacity-100 transition-all duration-300" />
                        </div>
                        <div class="swiper-slide">
                            <img src="images/clients/10.jpg" alt="Client 6"
                                class="h-32 mx-auto filter grayscale hover:grayscale-0 hover:opacity-100 transition-all duration-300" />
                        </div>
                        <div class="swiper-slide">
                            <img src="images/clients/11.jpg" alt="Client 6"
                                class="h-32 mx-auto filter grayscale hover:grayscale-0 hover:opacity-100 transition-all duration-300" />
                        </div>
                        <div class="swiper-slide">
                            <img src="images/clients/12.jpg" alt="Client 6"
                                class="h-32 mx-auto filter grayscale hover:grayscale-0 hover:opacity-100 transition-all duration-300" />
                        </div>
                        <div class="swiper-slide">
                            <img src="images/clients/13.jpg" alt="Client 6"
                                class="h-32 mx-auto filter grayscale hover:grayscale-0 hover:opacity-100 transition-all duration-300" />
                        </div>
                        <div class="swiper-slide">
                            <img src="images/clients/14.jpg" alt="Client 6"
                                class="h-32 mx-auto filter grayscale hover:grayscale-0 hover:opacity-100 transition-all duration-300" />
                        </div>
                        <div class="swiper-slide">
                            <img src="images/clients/15.jpg" alt="Client 6"
                                class="h-32 mx-auto filter grayscale hover:grayscale-0 hover:opacity-100 transition-all duration-300" />
                        </div>
                        <div class="swiper-slide">
                            <img src="images/clients/16.jpg" alt="Client 6"
                                class="h-32 mx-auto filter grayscale hover:grayscale-0 hover:opacity-100 transition-all duration-300" />
                        </div>
                        <div class="swiper-slide">
                            <img src="images/clients/17.jpg" alt="Client 6"
                                class="h-32 mx-auto filter grayscale hover:grayscale-0 hover:opacity-100 transition-all duration-300" />
                        </div>
                        <div class="swiper-slide">
                            <img src="images/clients/18.jpg" alt="Client 6"
                                class="h-32 mx-auto filter grayscale hover:grayscale-0 hover:opacity-100 transition-all duration-300" />
                        </div>
                    </div>
                    <!-- Clients Navigation (optional) -->
                    <!--
                                                                                          <div class="swiper-button-prev clients-prev text-custom-yellow"></div>
                                                                                          <div class="swiper-button-next clients-next text-custom-yellow"></div>
                                                                                          -->
                </div>
            </div>
        </section>

    <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/dbonline/public_html/cesraweb.dunesberry.online/resources/views/home.blade.php ENDPATH**/ ?>