<?php $__env->startSection('title', 'Careers - Cesra Company Limited'); ?>

<?php $__env->startSection('content'); ?>
    <style>
        /* Reusing sidebar styles from Insights page */
        .sidebar-widget {
            background: rgba(255, 255, 255, 0.5);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.7);
            padding: 1.5rem;
            box-shadow: 0 4px 6px -1px rgb(0 0 0 / 0.05);
        }

        .sidebar-title {
            font-weight: 800;
            font-size: 1.25rem;
            color: #2c3a5a;
            margin-bottom: 1rem;
            padding-bottom: 0.75rem;
            border-bottom: 1px solid #e5e7eb;
        }

        .sidebar-category-link {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0.5rem 0.25rem;
            color: #4b5563;
            transition: color 0.3s ease;
            border-radius: 0.375rem;
        }

        .sidebar-category-link:hover {
            color: #e82424;
            background-color: rgba(255, 255, 255, 0.5);
        }

        .sidebar-category-link.active {
            color: #e82424;
            font-weight: 700;
            background-color: rgba(232, 36, 36, 0.05);
        }
    </style>

    <!-- ================== REUSABLE PAGE HEADER ================== -->
 <?php if (isset($component)) { $__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.page-header','data' => ['title' => 'Careers','subtitle' => 'Join a team of innovators and builders shaping the future of Saudi Arabia. Discover your next opportunity at Cesra.','image' => ''.e(asset('images/services/4.jpg')).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('page-header'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Careers','subtitle' => 'Join a team of innovators and builders shaping the future of Saudi Arabia. Discover your next opportunity at Cesra.','image' => ''.e(asset('images/services/4.jpg')).'']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e)): ?>
<?php $attributes = $__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e; ?>
<?php unset($__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e)): ?>
<?php $component = $__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e; ?>
<?php unset($__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e); ?>
<?php endif; ?>



    <!-- ================== JOB LISTINGS & SIDEBAR SECTION ================== -->
    <section class="py-20 bg-gray-50" x-data="careers_page()">
        <div class="container mx-auto px-4">
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8 lg:gap-12">

                <!-- Main Content: Job Listings -->
                <div class="lg:col-span-2">
                    <div class="flex flex-col sm:flex-row justify-between items-center mb-8">
                        <h2 class="text-3xl font-extrabold text-custom-secondary">Current Openings</h2>
                        <p class="text-gray-500 mt-2 sm:mt-0">Showing <span x-text="filtered_jobs.length"></span> jobs</p>
                    </div>

                    <div class="space-y-6">
                        <template x-for="job in filtered_jobs" :key="job.id">
                            <div class="bg-white p-6 shadow-md hover:shadow-xl transition-shadow duration-300 flex flex-col sm:flex-row items-center justify-between gap-4"
                                x-transition:enter="transition ease-out duration-300"
                                x-transition:enter-start="opacity-0 transform -translate-x-4"
                                x-transition:enter-end="opacity-100 transform translate-x-0">
                                <div>
                                    <h3
                                        class="text-xl font-bold text-custom-secondary hover:text-custom-yellow transition-colors">
                                        <a href="#" x-text="job.title"></a>
                                    </h3>
                                    <div class="flex items-center gap-4 text-sm text-gray-500 mt-2">
                                        <span class="flex items-center gap-2"><i class="fas fa-map-marker-alt"></i> <span
                                                x-text="job.location"></span></span>
                                        <span class="flex items-center gap-2"><i class="fas fa-clock"></i> <span
                                                x-text="job.type"></span></span>
                                    </div>
                                </div>
                                <div class="flex-shrink-0 w-full sm:w-auto">
                                    <a href="careers/new"
                                        class="block w-full text-center bg-custom-yellow text-white px-6 py-3 hover:bg-custom-secondary transition-colors font-semibold">
                                        View & Apply
                                    </a>
                                </div>
                            </div>
                        </template>
                    </div>

                    <!-- No Results Message -->
                    <div x-show="filtered_jobs.length === 0" class="text-center py-16 text-gray-500 bg-white shadow-md">
                        <h3 class="text-2xl font-bold text-custom-secondary">No Matching Openings</h3>
                        <p class="mt-2">There are currently no positions matching your search. Please check back later.
                        </p>
                    </div>
                </div>

                <!-- Sidebar -->
                <aside class="lg:col-span-1 space-y-8">
                    <!-- Search Widget -->
                    <div class="sidebar-widget">
                        <h3 class="sidebar-title">Search Jobs</h3>
                        <div class="relative">
                            <input type="text" x-model.debounce.300ms="search_term" placeholder="Keyword, title..."
                                class="w-full border-gray-300 shadow-inner focus:ring-custom-yellow focus:border-custom-yellow">
                            <i class="fas fa-search absolute top-1/2 right-4 -translate-y-1/2 text-gray-400"></i>
                        </div>
                    </div>

                    <!-- Categories Widget -->
                    <div class="sidebar-widget">
                        <h3 class="sidebar-title">Job Categories</h3>
                        <ul class="space-y-1">
                            <li><a @click.prevent="category_filter = 'all'" href="#" class="sidebar-category-link"
                                    :class="{ 'active': category_filter === 'all' }"><span>All Departments</span> <span
                                        x-text="jobs.length"></span></a></li>
                            <template x-for="category in categories" :key="category.name">
                                <li><a @click.prevent="category_filter = category.name" href="#"
                                        class="sidebar-category-link"
                                        :class="{ 'active': category_filter === category.name }"><span
                                            x-text="category.name"></span> <span x-text="category.count"></span></a></li>
                            </template>
                        </ul>
                    </div>
                </aside>

            </div>
        </div>
    </section>
    <script>
        function careers_page() {
            return {
                search_term: '',
                category_filter: 'all',
                jobs: [{
                        id: 1,
                        title: 'Senior Civil Engineer',
                        category: 'Engineering',
                        location: 'Riyadh, KSA',
                        type: 'Full-Time'
                    },
                    {
                        id: 2,
                        title: 'Project Manager',
                        category: 'Management',
                        location: 'Riyadh, KSA',
                        type: 'Full-Time'
                    },
                    {
                        id: 3,
                        title: 'HSE Officer',
                        category: 'Safety',
                        location: 'Jeddah, KSA',
                        type: 'Full-Time'
                    },
                    {
                        id: 4,
                        title: 'Mechanical Engineer (MEP)',
                        category: 'Engineering',
                        location: 'Riyadh, KSA',
                        type: 'Full-Time'
                    },
                    {
                        id: 5,
                        title: 'Quantity Surveyor',
                        category: 'Engineering',
                        location: 'Dammam, KSA',
                        type: 'Contract'
                    },
                    {
                        id: 6,
                        title: 'Site Supervisor',
                        category: 'Management',
                        location: 'Riyadh, KSA',
                        type: 'Full-Time'
                    },
                    {
                        id: 7,
                        title: 'Accountant',
                        category: 'Finance',
                        location: 'Riyadh, KSA',
                        type: 'Full-Time'
                    },
                ],

                get categories() {
                    const counts = this.jobs.reduce((acc, job) => {
                        acc[job.category] = (acc[job.category] || 0) + 1;
                        return acc;
                    }, {});
                    return Object.keys(counts).map(name => ({
                        name,
                        count: counts[name]
                    }));
                },

                get filtered_jobs() {
                    let filtered = this.jobs;

                    if (this.category_filter !== 'all') {
                        filtered = filtered.filter(job => job.category === this.category_filter);
                    }

                    if (this.search_term.trim() !== '') {
                        filtered = filtered.filter(job =>
                            job.title.toLowerCase().includes(this.search_term.toLowerCase())
                        );
                    }

                    return filtered;
                },
            }
        }

        // Standard on-scroll animation observer
        document.addEventListener('DOMContentLoaded', () => {
            const animatedElements = document.querySelectorAll('.animate-on-scroll');
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.classList.add('is-visible');
                    }
                });
            }, {
                threshold: 0.1
            });
            animatedElements.forEach(el => observer.observe(el));
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/dbonline/public_html/cesraweb.dunesberry.online/resources/views/careers/index.blade.php ENDPATH**/ ?>