<?php $__env->startSection('title', 'Partners & Suppliers - Cesra Company Limited'); ?>

<?php $__env->startSection('content'); ?>
    <style>
        /* ========================================================================== */
        /*           CUSTOM FILE INPUT STYLES FOR FORMS                             */
        /* ========================================================================== */

        .file-input {
            @apply mt-1 block w-full text-sm text-gray-500;
            @apply file:mr-4 file:py-2 file:px-4;
            @apply file:rounded-md file:border-0;
            @apply file:text-sm file:font-semibold;
            @apply file:bg-custom-yellow/10 file:text-custom-yellow;
            @apply hover:file:bg-custom-yellow/20;
            @apply file:cursor-pointer;
        }
    </style>
    <!-- ================== REUSABLE PAGE HEADER ================== -->
    <?php if (isset($component)) { $__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.page-header','data' => ['title' => 'Partners & Suppliers','subtitle' => 'Join our network of trusted partners and suppliers dedicated to building the future of Saudi Arabia with excellence and integrity.','image' => 'images/bg/1.jpg']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('page-header'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Partners & Suppliers','subtitle' => 'Join our network of trusted partners and suppliers dedicated to building the future of Saudi Arabia with excellence and integrity.','image' => 'images/bg/1.jpg']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e)): ?>
<?php $attributes = $__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e; ?>
<?php unset($__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e)): ?>
<?php $component = $__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e; ?>
<?php unset($__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e); ?>
<?php endif; ?>

    <!-- ================== PARTNER WITH CESRA INTRODUCTION ================== -->
    <section class="py-20 bg-white">
        <div class="container mx-auto px-4">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                <!-- Left Column: Text Content -->
                <div class="animate-on-scroll">
                    <p class="text-gray-500 font-medium mb-2">Building Strong Alliances</p>
                    <h2 class="text-3xl sm:text-4xl font-extrabold text-custom-secondary leading-tight">
                        Partner with a Leader in Saudi Construction
                    </h2>
                    <div class="w-16 h-1 bg-custom-yellow my-6"></div>
                    <p class="text-gray-600 leading-relaxed mb-4">
                        At Cesra, we believe that strong partnerships are the foundation of every successful project. We are
                        committed to building long-term, trust-based relationships with suppliers, subcontractors, and
                        third-party companies who share our dedication to quality, safety, and innovation.
                    </p>
                    <p class="text-gray-600 leading-relaxed">
                        By joining our network, you become part of a collaborative ecosystem aligned with the ambitious
                        goals of Vision 2030. We seek partners who are leaders in their fields and are ready to contribute
                        to landmark projects across the Kingdom.
                    </p>
                </div>
                <!-- Right Column: Image -->
                <div class="relative animate-on-scroll" style="animation-delay: 0.1s;">
                    <img src="images/bg/3.jpg" alt="Partnering with Cesra"
                        class="rounded-lg shadow-2xl w-full h-full object-cover" />
                </div>
            </div>
        </div>
    </section>

    <!-- ================== REGISTRATION FORMS SECTION ================== -->
    <section class="py-20 bg-gray-50" x-data="{ activeTab: 'supplier' }">
        <div class="container mx-auto px-4">
            <div class="text-center mb-12">
                <h2 class="text-3xl sm:text-4xl font-extrabold text-custom-secondary">Registration Portal</h2>
                <p class="mt-4 max-w-2xl mx-auto text-gray-600">
                    Please select the appropriate registration type and complete the form to begin the pre-qualification
                    process.
                </p>
            </div>

            <!-- Tab Buttons -->
            <div class="flex justify-center border-b mb-8">
                <button @click="activeTab = 'supplier'"
                    :class="{ 'border-custom-yellow text-custom-yellow': activeTab === 'supplier', 'border-transparent text-gray-500 hover:text-gray-700': activeTab !== 'supplier' }"
                    class="px-6 py-3 font-semibold text-lg border-b-2 transition-colors duration-300">
                    Supplier Registration
                </button>
                <button @click="activeTab = 'third_party'"
                    :class="{ 'border-custom-yellow text-custom-yellow': activeTab === 'third_party', 'border-transparent text-gray-500 hover:text-gray-700': activeTab !== 'third_party' }"
                    class="px-6 py-3 font-semibold text-lg border-b-2 transition-colors duration-300">
                    Third-Party & Subcontractor
                </button>
            </div>

            <!-- Form Panels -->
            <div class="max-w-4xl mx-auto">
                <!-- Supplier Registration Form -->
                <div x-show="activeTab === 'supplier'" x-transition class="bg-white p-8 shadow-xl">
                    <form action="#" method="POST" enctype="multipart/form-data"
                        class="space-y-10 bg-white p-8 md:p-12 ">
                        <?php echo csrf_field(); ?>

                        <!-- Company Details -->
                        <div>
                            <h3 class="text-2xl font-bold text-custom-secondary border-l-4 border-custom-yellow pl-4 mb-8">
                                Company Details
                            </h3>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                                <div>
                                    <label for="sup_company_name"
                                        class="block text-sm font-semibold text-gray-700 mb-2">Company Name</label>
                                    <input type="text" id="sup_company_name" required
                                        class="block w-full border border-gray-300 bg-gray-50 text-gray-800 text-base py-3 px-4 
                           focus:outline-none focus:ring-2 focus:ring-custom-yellow focus:border-custom-yellow transition-all duration-300">
                                </div>

                                <div>
                                    <label for="sup_cr_number"
                                        class="block text-sm font-semibold text-gray-700 mb-2">Commercial Registration (CR)
                                        No.</label>
                                    <input type="text" id="sup_cr_number" required
                                        class="block w-full border border-gray-300 bg-gray-50 text-gray-800 text-base py-3 px-4 
                           focus:outline-none focus:ring-2 focus:ring-custom-yellow focus:border-custom-yellow transition-all duration-300">
                                </div>

                                <div>
                                    <label for="sup_vat_number" class="block text-sm font-semibold text-gray-700 mb-2">VAT
                                        Number</label>
                                    <input type="text" id="sup_vat_number" required
                                        class="block w-full border border-gray-300 bg-gray-50 text-gray-800 text-base py-3 px-4 
                           focus:outline-none focus:ring-2 focus:ring-custom-yellow focus:border-custom-yellow transition-all duration-300">
                                </div>

                                <div>
                                    <label for="sup_materials"
                                        class="block text-sm font-semibold text-gray-700 mb-2">Materials/Products
                                        Supplied</label>
                                    <input type="text" id="sup_materials"
                                        placeholder="e.g., Concrete, Steel, MEP Components" required
                                        class="block w-full border border-gray-300 bg-gray-50 text-gray-800 text-base py-3 px-4 
                           focus:outline-none focus:ring-2 focus:ring-custom-yellow focus:border-custom-yellow transition-all duration-300">
                                </div>
                            </div>
                        </div>

                        <!-- Contact Person -->
                        <div>
                            <h3 class="text-2xl font-bold text-custom-secondary border-l-4 border-custom-yellow pl-4 mb-8">
                                Contact Person
                            </h3>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                                <div>
                                    <label for="sup_contact_name"
                                        class="block text-sm font-semibold text-gray-700 mb-2">Full Name</label>
                                    <input type="text" id="sup_contact_name" required
                                        class="block w-full border border-gray-300 bg-gray-50 text-gray-800 text-base py-3 px-4 
                           focus:outline-none focus:ring-2 focus:ring-custom-yellow focus:border-custom-yellow transition-all duration-300">
                                </div>

                                <div>
                                    <label for="sup_contact_email"
                                        class="block text-sm font-semibold text-gray-700 mb-2">Email Address</label>
                                    <input type="email" id="sup_contact_email" required
                                        class="block w-full border border-gray-300 bg-gray-50 text-gray-800 text-base py-3 px-4 
                           focus:outline-none focus:ring-2 focus:ring-custom-yellow focus:border-custom-yellow transition-all duration-300">
                                </div>
                            </div>
                        </div>

                        <!-- Document Uploads -->
                        <div>
                            <h3 class="text-2xl font-bold text-custom-secondary border-l-4 border-custom-yellow pl-4 mb-8">
                                Document Uploads
                            </h3>

                            <div class="space-y-4">
                                <label for="sup_cr_doc" class="block text-sm font-semibold text-gray-700 mb-1">
                                    Commercial Registration Certificate
                                </label>
                                <input type="file" id="sup_cr_doc" required
                                    class="block w-full text-sm text-gray-700 py-3 px-3 border border-gray-300 cursor-pointer bg-gray-50 
                       file:mr-4 file:py-2.5 file:px-5 file:rounded-md file:border-0 file:text-sm file:font-semibold 
                       file:bg-custom-yellow/10 file:text-custom-yellow hover:file:bg-custom-yellow/20 focus:outline-none">
                            </div>
                        </div>

                        <!-- Submit -->
                        <div>
                            <button type="submit"
                                class="w-full bg-custom-yellow text-white px-8 py-4 text-lg font-semibold 
                   hover:bg-custom-secondary transition-all duration-300 shadow-md hover:shadow-lg">
                                Submit for Prequalification
                            </button>
                        </div>
                    </form>

                </div>

                <!-- Third-Party / Subcontractor Registration Form -->
                <div x-show="activeTab === 'third_party'" x-transition style="display: none;"
                    class="bg-white p-8 shadow-xl">
                    <form action="#" method="POST" enctype="multipart/form-data"
                        class="space-y-10 bg-white p-8 md:p-12">
                        <?php echo csrf_field(); ?>

                        <!-- Company Details Section -->
                        <div>
                            <h3 class="text-2xl font-bold text-custom-secondary border-l-4 border-custom-yellow pl-4 mb-8">
                                Company Details
                            </h3>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                                <div>
                                    <label for="tp_company_name"
                                        class="block text-sm font-semibold text-gray-700 mb-2">Company Name</label>
                                    <input type="text" id="tp_company_name" name="tp_company_name" required
                                        class="block w-full border border-gray-300 bg-gray-50 text-gray-800 text-base py-3 px-4 
                           focus:outline-none focus:ring-2 focus:ring-custom-yellow focus:border-custom-yellow transition-all duration-300">
                                </div>

                                <div>
                                    <label for="tp_cr_number" class="block text-sm font-semibold text-gray-700 mb-2">
                                        Commercial Registration (CR) No.
                                    </label>
                                    <input type="text" id="tp_cr_number" name="tp_cr_number" required
                                        class="block w-full border border-gray-300 bg-gray-50 text-gray-800 text-base py-3 px-4 
                           focus:outline-none focus:ring-2 focus:ring-custom-yellow focus:border-custom-yellow transition-all duration-300">
                                </div>

                                <div>
                                    <label for="tp_specialization" class="block text-sm font-semibold text-gray-700 mb-2">
                                        Area of Specialization
                                    </label>
                                    <input type="text" id="tp_specialization" name="tp_specialization" required
                                        placeholder="e.g., MEP Works, Earthworks, Finishing"
                                        class="block w-full border border-gray-300 bg-gray-50 text-gray-800 text-base py-3 px-4 
                              focus:outline-none focus:ring-2 focus:ring-custom-yellow focus:border-custom-yellow transition-all duration-300">
                                </div>

                                <div>
                                    <label for="tp_classification" class="block text-sm font-semibold text-gray-700 mb-2">
                                        Contractor Classification
                                    </label>
                                    <input type="text" id="tp_classification" name="tp_classification" required
                                        placeholder="e.g., Grade I, Grade II"
                                        class="block w-full border border-gray-300 bg-gray-50 text-gray-800 text-base py-3 px-4 
                              focus:outline-none focus:ring-2 focus:ring-custom-yellow focus:border-custom-yellow transition-all duration-300">
                                </div>
                            </div>
                        </div>

                        <!-- Contact Person Section -->
                        <div>
                            <h3 class="text-2xl font-bold text-custom-secondary border-l-4 border-custom-yellow pl-4 mb-8">
                                Contact Person
                            </h3>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                                <div>
                                    <label for="tp_contact_name"
                                        class="block text-sm font-semibold text-gray-700 mb-2">Full Name</label>
                                    <input type="text" id="tp_contact_name" name="tp_contact_name" required
                                        class="block w-full border border-gray-300 bg-gray-50 text-gray-800 text-base py-3 px-4 
                           focus:outline-none focus:ring-2 focus:ring-custom-yellow focus:border-custom-yellow transition-all duration-300">
                                </div>

                                <div>
                                    <label for="tp_contact_email"
                                        class="block text-sm font-semibold text-gray-700 mb-2">Email Address</label>
                                    <input type="email" id="tp_contact_email" name="tp_contact_email" required
                                        class="block w-full border border-gray-300 bg-gray-50 text-gray-800 text-base py-3 px-4 
                           focus:outline-none focus:ring-2 focus:ring-custom-yellow focus:border-custom-yellow transition-all duration-300">
                                </div>
                            </div>
                        </div>

                        <!-- Document Uploads -->
                        <div>
                            <h3 class="text-2xl font-bold text-custom-secondary border-l-4 border-custom-yellow pl-4 mb-8">
                                Document Uploads
                            </h3>

                            <div class="space-y-6">
                                <div>
                                    <label for="tp_cr_doc" class="block text-sm font-semibold text-gray-700 mb-2">
                                        Company Profile & CR Certificate
                                    </label>
                                    <input type="file" id="tp_cr_doc" name="tp_cr_doc" required
                                        class="block w-full text-sm text-gray-700 py-3 px-3 border border-gray-300 cursor-pointer bg-gray-50 
                           file:mr-4 file:py-2.5 file:px-5 file:rounded-md file:border-0 file:text-sm file:font-semibold 
                           file:bg-custom-yellow/10 file:text-custom-yellow hover:file:bg-custom-yellow/20 focus:outline-none">
                                </div>

                                <div>
                                    <label for="tp_prequal_doc" class="block text-sm font-semibold text-gray-700 mb-2">
                                        Prequalification Documents
                                    </label>
                                    <input type="file" id="tp_prequal_doc" name="tp_prequal_doc" required
                                        class="block w-full text-sm text-gray-700 py-3 px-3 border border-gray-300 cursor-pointer bg-gray-50 
                           file:mr-4 file:py-2.5 file:px-5 file:rounded-md file:border-0 file:text-sm file:font-semibold 
                           file:bg-custom-yellow/10 file:text-custom-yellow hover:file:bg-custom-yellow/20 focus:outline-none">
                                </div>
                            </div>
                        </div>

                        <!-- Submit Button -->
                        <div>
                            <button type="submit"
                                class="w-full bg-custom-yellow text-white px-8 py-4 text-lg font-semibold 
                   hover:bg-custom-secondary transition-all duration-300 shadow-md hover:shadow-lg">
                                Submit for Prequalification
                            </button>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </section>
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            // Initialize Jarallax for the header
            jarallax(document.querySelectorAll('.jarallax'), {
                speed: 0.4
            });

            // Initialize on-scroll animations
            const animatedElements = document.querySelectorAll('.animate-on-scroll');
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.classList.add('is-visible');
                    }
                });
            }, {
                threshold: 0.1
            });
            animatedElements.forEach(el => observer.observe(el));
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/theroof/cesra/resources/views/supplier.blade.php ENDPATH**/ ?>