<?php $__env->startSection('title', 'Senior Civil Engineer - Cesra Careers'); ?>

<?php $__env->startSection('content'); ?>

    <style>
        /* Styles for the article-like content for better readability */
        .job-content h2 {
            @apply text-2xl font-bold text-custom-secondary mt-8 mb-4 border-b pb-2;
        }

        .job-content p {
            @apply text-gray-700 leading-relaxed mb-6;
        }

        .job-content ul {
            @apply list-disc list-inside space-y-2 mb-6 pl-4 text-gray-700;
        }

        /* Make the sidebar sticky on larger screens */
        @media (min-width: 1024px) {
            .sticky-sidebar {
                position: sticky;
                top: 120px;
                /* Adjust based on your header height */
            }
        }
    </style>
    <!-- ================== DYNAMIC PAGE HEADER ================== -->
    
    <section class="relative h-[45vh] min-h-[350px] text-white flex items-center justify-center text-center">
        <div class="jarallax absolute inset-0 z-0">
            <img class="jarallax-img" src="<?php echo e(asset('images/bg/3.jpg')); ?>" alt="Careers at Cesra">
            <div class="absolute inset-0 bg-gradient-to-t from-black/80 to-transparent"></div>
        </div>
        <div class="relative z-10 container mx-auto px-4 animate-on-scroll">
            <div class="flex justify-center items-center gap-4 mb-4 text-gray-300">
                <span class="flex items-center gap-2"><i class="fas fa-map-marker-alt text-custom-yellow"></i> Riyadh,
                    KSA</span>
                <span class="text-gray-500">&bull;</span>
                <span class="flex items-center gap-2"><i class="fas fa-briefcase text-custom-yellow"></i> Engineering</span>
                <span class="text-gray-500">&bull;</span>
                <span class="flex items-center gap-2"><i class="fas fa-clock text-custom-yellow"></i> Full-Time</span>
            </div>
            <h1 class="text-3xl sm:text-4xl md:text-5xl font-extrabold tracking-tight max-w-4xl mx-auto">
                Senior Civil Engineer
            </h1>
            <div class="mt-8 text-sm font-medium tracking-wider uppercase">
                <a href="/" class="text-gray-300 hover:text-custom-yellow transition-colors">Home</a>
                <span class="mx-2 text-gray-500">/</span>
                <a href="/careers" class="text-gray-300 hover:text-custom-yellow transition-colors">Careers</a>
                <span class="mx-2 text-gray-500">/</span>
                <span class="text-white">Job Details</span>
            </div>
        </div>
    </section>

    <!-- ================== JOB DETAILS & APPLY FORM SECTION ================== -->
    <section class="py-20 bg-gray-50">
        <div class="container mx-auto px-4">
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8 lg:gap-12">

                <!-- Main Content: Job Description -->
                <article
                    class="lg:col-span-2 bg-white p-8 md:p-12 rounded-2xl shadow-lg border border-gray-100 hover:shadow-2xl transition-all duration-500">
                    <div class="border-b pb-8 ">
                        <h1 class="text-3xl md:text-4xl font-extrabold text-custom-secondary">Senior Civil Engineer</h1>
                        <div class="flex flex-wrap items-center gap-x-6 gap-y-2 text-gray-500 mt-4">
                            <span class="flex items-center gap-2">
                                <i class="fas fa-map-marker-alt text-custom-yellow"></i>
                                <span>Riyadh, KSA</span>
                            </span>
                            <span class="text-gray-300 hidden sm:block">&bull;</span>
                            <span class="flex items-center gap-2">
                                <i class="fas fa-briefcase text-custom-yellow"></i>
                                <span>Engineering</span>
                            </span>
                            <span class="text-gray-300 hidden sm:block">&bull;</span>
                            <span class="flex items-center gap-2">
                                <i class="fas fa-clock text-custom-yellow"></i>
                                <span>Full-Time</span>
                            </span>
                        </div>
                    </div>
                    <div class="job-content mt-4 space-y-10">
                        <!-- Job Description -->

                        <section class="animate-fade-in">

                            <div class="flex items-center gap-3 mb-4">
                                <div
                                    class="w-10 h-10 flex items-center justify-center rounded-full bg-custom-yellow/10 text-custom-yellow text-xl">
                                    <i class="fas fa-briefcase"></i>
                                </div>
                                <h2 class="text-2xl font-extrabold text-custom-secondary">Job Description</h2>
                            </div>
                            <p class="text-gray-700 leading-relaxed">
                                We are seeking a highly skilled and experienced <span
                                    class="font-semibold text-custom-secondary">Senior Civil Engineer</span> to join our
                                dynamic team in Riyadh.
                                The ideal candidate will lead complex infrastructure and construction projects from
                                conception to completion,
                                ensuring the highest standards of quality, safety, and efficiency — contributing to the
                                vision of <span class="font-medium">Saudi Vision 2030</span>.
                            </p>
                        </section>

                        <!-- Key Responsibilities -->
                        <section class="animate-fade-in" style="animation-delay: 0.1s;">
                            <div class="flex items-center gap-3 mb-4">
                                <div
                                    class="w-10 h-10 flex items-center justify-center rounded-full bg-custom-yellow/10 text-custom-yellow text-xl">
                                    <i class="fas fa-tasks"></i>
                                </div>
                                <h2 class="text-2xl font-extrabold text-custom-secondary">Key Responsibilities</h2>
                            </div>
                            <ul class="list-none space-y-3 text-gray-700">
                                <li class="flex items-start gap-3">
                                    <i class="fas fa-check text-custom-yellow mt-1"></i>
                                    <span>Lead the design, planning, and execution of civil engineering projects, including
                                        water networks, roadworks, and structural developments.</span>
                                </li>
                                <li class="flex items-start gap-3">
                                    <i class="fas fa-check text-custom-yellow mt-1"></i>
                                    <span>Manage project timelines, budgets, and resources to ensure on-time and on-budget
                                        delivery.</span>
                                </li>
                                <li class="flex items-start gap-3">
                                    <i class="fas fa-check text-custom-yellow mt-1"></i>
                                    <span>Conduct site investigations, feasibility studies, and prepare detailed technical
                                        reports.</span>
                                </li>
                                <li class="flex items-start gap-3">
                                    <i class="fas fa-check text-custom-yellow mt-1"></i>
                                    <span>Ensure all work complies with industry standards, legal regulations, and company
                                        HSE policies.</span>
                                </li>
                                <li class="flex items-start gap-3">
                                    <i class="fas fa-check text-custom-yellow mt-1"></i>
                                    <span>Collaborate with architects, contractors, and multidisciplinary teams to achieve
                                        project success.</span>
                                </li>
                                <li class="flex items-start gap-3">
                                    <i class="fas fa-check text-custom-yellow mt-1"></i>
                                    <span>Mentor and provide technical guidance to junior engineers and site staff.</span>
                                </li>
                            </ul>
                        </section>

                        <!-- Qualifications & Experience -->
                        <section class="animate-fade-in" style="animation-delay: 0.2s;">
                            <div class="flex items-center gap-3 mb-4">
                                <div
                                    class="w-10 h-10 flex items-center justify-center rounded-full bg-custom-yellow/10 text-custom-yellow text-xl">
                                    <i class="fas fa-graduation-cap"></i>
                                </div>
                                <h2 class="text-2xl font-extrabold text-custom-secondary">Qualifications & Experience</h2>
                            </div>
                            <ul class="list-none space-y-3 text-gray-700">
                                <li class="flex items-start gap-3">
                                    <i class="fas fa-star text-custom-yellow mt-1"></i>
                                    <span>Bachelor's degree in Civil Engineering or related field (Master’s
                                        preferred).</span>
                                </li>
                                <li class="flex items-start gap-3">
                                    <i class="fas fa-star text-custom-yellow mt-1"></i>
                                    <span>8–10 years of experience managing large-scale construction projects in Saudi
                                        Arabia.</span>
                                </li>
                                <li class="flex items-start gap-3">
                                    <i class="fas fa-star text-custom-yellow mt-1"></i>
                                    <span>Professional Engineer (PE) or equivalent certification preferred.</span>
                                </li>
                                <li class="flex items-start gap-3">
                                    <i class="fas fa-star text-custom-yellow mt-1"></i>
                                    <span>Proficient in AutoCAD, Civil 3D, and project management software.</span>
                                </li>
                                <li class="flex items-start gap-3">
                                    <i class="fas fa-star text-custom-yellow mt-1"></i>
                                    <span>Strong leadership, communication, and analytical problem-solving skills.</span>
                                </li>
                                <li class="flex items-start gap-3">
                                    <i class="fas fa-star text-custom-yellow mt-1"></i>
                                    <span>Thorough understanding of local construction codes and safety regulations.</span>
                                </li>
                                <li class="flex items-start gap-3">
                                    <i class="fas fa-star text-custom-yellow mt-1"></i>
                                    <span>Fluency in both Arabic and English is required.</span>
                                </li>
                            </ul>
                        </section>
                    </div>
                </article>

                <!-- Tailwind fade-in animation -->
                <style>
                    @keyframes fadeInUp {
                        0% {
                            opacity: 0;
                            transform: translateY(25px);
                        }

                        100% {
                            opacity: 1;
                            transform: translateY(0);
                        }
                    }

                    .animate-fade-in {
                        animation: fadeInUp 0.8s ease forwards;
                        opacity: 0;
                    }
                </style>


                <!-- ============== SIDEBAR ============== -->
                <aside class="lg:col-span-1">
                    <div class="sticky-sidebar space-y-8">
                        <!-- Job Summary Card -->
                        <div class="bg-white p-6 rounded-lg shadow-lg">
                            <h3 class="text-xl font-bold text-custom-secondary border-b pb-3 mb-4">Job Overview</h3>
                            <ul class="space-y-4 text-gray-600">
                                <li class="flex items-center"><i class="fas fa-calendar-alt w-6 text-custom-yellow"></i>
                                    <strong>Posted on:</strong> <span class="ml-auto">June 25, 2025</span>
                                </li>
                                <li class="flex items-center"><i class="fas fa-map-marker-alt w-6 text-custom-yellow"></i>
                                    <strong>Location:</strong> <span class="ml-auto">Riyadh, KSA</span>
                                </li>
                                <li class="flex items-center"><i class="fas fa-briefcase w-6 text-custom-yellow"></i>
                                    <strong>Department:</strong> <span class="ml-auto">Engineering</span>
                                </li>
                                <li class="flex items-center"><i class="fas fa-clock w-6 text-custom-yellow"></i>
                                    <strong>Job Type:</strong> <span class="ml-auto">Full-Time</span>
                                </li>
                                <li class="flex items-center"><i class="fas fa-layer-group w-6 text-custom-yellow"></i>
                                    <strong>Experience:</strong> <span class="ml-auto">8-10 Years</span>
                                </li>
                                <li class="flex items-center"><i class="fas fa-dollar-sign w-6 text-custom-yellow"></i>
                                    <strong>Salary:</strong> <span class="ml-auto">Competitive</span>
                                </li>
                            </ul>
                        </div>

                        <!-- Apply Now Form -->
                        <div class="bg-white p-6 rounded-lg shadow-lg">
                            <h3 class="text-xl font-bold text-custom-secondary border-b pb-3 mb-6">Apply For This Job</h3>
                            <form action="#" method="POST" enctype="multipart/form-data" class="space-y-5">
                                <?php echo csrf_field(); ?>

                                <!-- Full Name -->
                                <div>
                                    <label for="name" class="block text-sm font-semibold text-gray-700 mb-1">Full
                                        Name</label>
                                    <input type="text" name="name" id="name" required
                                        class="block w-full rounded-lg border border-gray-300 bg-gray-50 text-gray-800 text-base py-3 px-4 
                   focus:outline-none focus:ring-2 focus:ring-custom-yellow focus:border-custom-yellow transition-all duration-200">
                                </div>

                                <!-- Email -->
                                <div>
                                    <label for="email" class="block text-sm font-semibold text-gray-700 mb-1">Email
                                        Address</label>
                                    <input type="email" name="email" id="email" required
                                        class="block w-full rounded-lg border border-gray-300 bg-gray-50 text-gray-800 text-base py-3 px-4 
                   focus:outline-none focus:ring-2 focus:ring-custom-yellow focus:border-custom-yellow transition-all duration-200">
                                </div>

                                <!-- Phone -->
                                <div>
                                    <label for="phone" class="block text-sm font-semibold text-gray-700 mb-1">Phone
                                        Number</label>
                                    <input type="tel" name="phone" id="phone"
                                        class="block w-full rounded-lg border border-gray-300 bg-gray-50 text-gray-800 text-base py-3 px-4 
                   focus:outline-none focus:ring-2 focus:ring-custom-yellow focus:border-custom-yellow transition-all duration-200">
                                </div>

                                <!-- Resume -->
                                <div>
                                    <label for="resume" class="block text-sm font-semibold text-gray-700 mb-1">Upload
                                        Resume (PDF, DOC, DOCX)</label>
                                    <input type="file" name="resume" id="resume" required
                                        class="block w-full text-sm text-gray-700 py-3 px-3 border border-gray-300 rounded-lg cursor-pointer bg-gray-50 
                   file:mr-4 file:py-2.5 file:px-5 file:rounded-md file:border-0 file:text-sm file:font-semibold 
                   file:bg-custom-yellow/10 file:text-custom-yellow hover:file:bg-custom-yellow/20 focus:outline-none">
                                </div>

                                <!-- Cover Letter -->
                                <div>
                                    <label for="cover_letter" class="block text-sm font-semibold text-gray-700 mb-1">Cover
                                        Letter (Optional)</label>
                                    <textarea name="cover_letter" id="cover_letter" rows="4"
                                        class="block w-full rounded-lg border border-gray-300 bg-gray-50 text-gray-800 text-base py-3 px-4 
                   focus:outline-none focus:ring-2 focus:ring-custom-yellow focus:border-custom-yellow transition-all duration-200"></textarea>
                                </div>

                                <!-- Submit -->
                                <div>
                                    <button type="submit"
                                        class="w-full bg-custom-yellow text-white px-6 py-3.5 rounded-lg text-lg font-semibold 
                   hover:bg-custom-secondary transition-all duration-300 shadow-md hover:shadow-lg">
                                        Submit Application
                                    </button>
                                </div>
                            </form>

                        </div>
                    </div>
                </aside>
            </div>
        </div>
    </section>
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            jarallax(document.querySelectorAll('.jarallax'), {
                speed: 0.4
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/theroof/cesra/resources/views/careers/show.blade.php ENDPATH**/ ?>