<?php $__env->startSection('title', 'Our Projects - Cesra Company Limited'); ?>

<?php $__env->startSection('content'); ?>
    <style>
        /* ========================================================================== */
        /*           ISOTOPE.JS GALLERY STYLES (FINAL, CONFLICT-FREE VERSION)       */
        /* ========================================================================== */

        /* --- Filter Buttons (No Changes) --- */
        .project-filter-btn {
            padding: 0.75rem 1.5rem;
            font-weight: 600;
            background-color: white;
            color: #4b5563;
            border: 1px solid #e5e7eb;
            transition: all 0.3s ease;
            cursor: pointer;
        }

        .project-filter-btn:hover {
            background-color: #f3f4f6;
            color: #1f2f37;
        }

        .project-filter-btn.is-checked {
            background-color: #e82424;
            color: white;
            border-color: #e82424;
            box-shadow: 0 4px 6px -1px rgb(232 36 36 / 0.2), 0 2px 4px -2px rgb(232 36 36 / 0.1);
        }

        /* --- Isotope Grid & Item Styling --- */

        /* The main grid container */
        .isotope-grid {
            margin: 0 -10px;
            /* Adjust for gutter */
        }

        /* The Isotope item container.
                                                                                                   CRITICAL: It has NO transition, animation, or transform properties.
                                                                                                   Isotope will control these with inline styles. */
        .isotope-item {
            width: calc(33.333% - 20px);
            margin: 10px;
        }

        /* Responsive widths */
        @media (max-width: 1023px) {
            .isotope-item {
                width: calc(50% - 20px);
            }
        }

        @media (max-width: 767px) {
            .isotope-item {
                width: calc(100% - 20px);
            }
        }


        /* --- Project Card (These inner transitions are SAFE as they don't affect layout) --- */
        .project-card {
            position: relative;
            overflow: hidden;
            box-shadow: 0 10px 15px -3px rgb(0 0 0 / 0.1), 0 4px 6px -4px rgb(0 0 0 / 0.1);
            height: 400px;
        }

        .project-card-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.4s ease-out;
        }

        .project-card:hover .project-card-image img {
            transform: scale(1.1);
        }

        .project-card-overlay {
            position: absolute;
            inset: 0;
            display: flex;
            flex-direction: column;
            justify-content: flex-end;
            padding: 1.5rem;
            background: linear-gradient(to top, rgba(0, 0, 0, 0.8) 0%, transparent 60%);
            color: white;
        }

        .project-card-content {
            transform: translateY(20px);
            opacity: 1;
            transition: transform 0.4s ease-out, opacity 0.4s ease-out;
        }

        .project-card:hover .project-card-content {
            transform: translateY(0);
            opacity: 1;
        }

        .project-card-category {
            display: inline-block;
            background-color: #e82424;
            padding: 0.25rem 0.75rem;
            font-size: 0.75rem;
            font-weight: 600;
            /* border-radius: 9999px; */
            text-transform: uppercase;
        }

        .project-card-title {
            font-size: 1.5rem;
            font-weight: 800;
            margin-top: 0.5rem;
            line-height: 1.2;
        }

        .project-card-button {
            display: inline-flex;
            align-items: center;
            transform: translateY(20px);
            gap: 0.5rem;
            margin-top: 1rem;
            font-weight: 600;
            transition: transform 0.4s ease-out, opacity 0.4s ease-out;
            opacity: 0;
        }

        .project-card:hover .project-card-button {
            transform: translateY(0);
            opacity: 1;
        }

        .project-card-button:hover {
            color: #e82424;
        }

        .project-card-button i {
            transition: transform 0.3s ease;
        }

        .project-card-button:hover i {
            transform: translateX(4px);
        }
    </style>
    <!-- ================== REUSABLE PAGE HEADER ================== -->
    <?php if (isset($component)) { $__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.page-header','data' => ['title' => 'Our Projects','subtitle' => 'A portfolio of landmark projects that showcase our commitment to quality, safety, and engineering excellence across Saudi Arabia.','image' => 'images/project/1.jpg']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('page-header'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Our Projects','subtitle' => 'A portfolio of landmark projects that showcase our commitment to quality, safety, and engineering excellence across Saudi Arabia.','image' => 'images/project/1.jpg']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e)): ?>
<?php $attributes = $__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e; ?>
<?php unset($__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e)): ?>
<?php $component = $__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e; ?>
<?php unset($__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e); ?>
<?php endif; ?>
    <!-- ================== PROJECTS GALLERY SECTION (FINAL, CORRECT ISOTOPE IMPLEMENTATION) ================== -->
    <section class="py-20 bg-gray-50">
        <div class="container mx-auto px-4">
            <!-- Filter Buttons -->
            <div id="project-filters" class="flex flex-wrap justify-center gap-2 md:gap-4 mb-12">
                <button class="project-filter-btn is-checked" data-filter="*">All Projects</button>
                <button class="project-filter-btn" data-filter=".infrastructure">Infrastructure</button>
                <button class="project-filter-btn" data-filter=".governmental">Governmental</button>
                <button class="project-filter-btn" data-filter=".residential">Residential</button>
                <button class="project-filter-btn" data-filter=".commercial">Commercial</button>
            </div>

            <!-- Isotope Grid Container -->
            <div class="isotope-grid">

                <?php
                    $projects = [
                        [
                            'title' => 'Shaqra Wastewater Plant',
                            'category' => 'Infrastructure',
                            'image' => 'images/project/new/1.jpg',
                        ],
                        [
                            'title' => 'Private Villa, Al Muhamadiyah',
                            'category' => 'Residential',
                            'image' => 'images/project/new/2.jpg',
                        ],
                        [
                            'title' => 'Commercial Complex, Riyadh',
                            'category' => 'Commercial',
                            'image' => 'images/project/new/3.jpg',
                        ],
                        [
                            'title' => 'Al Hayer Staff Office Building',
                            'category' => 'Governmental',
                            'image' => 'images/project/new/4.jpg',
                        ],
                        [
                            'title' => 'Tayma Wastewater Plant',
                            'category' => 'Infrastructure',
                            'image' => 'images/project/new/5.jpg',
                        ],
                        [
                            'title' => 'Excess Control Project, Heet',
                            'category' => 'Infrastructure',
                            'image' => 'images/project/new/6.jpg',
                        ],
                        [
                            'title' => 'Luxury Residence, Riyadh',
                            'category' => 'Residential',
                            'image' => 'images/project/new/7.jpg',
                        ],
                        [
                            'title' => 'NWC Water Networks',
                            'category' => 'Governmental',
                            'image' => 'images/project/new/8.jpg',
                        ],
                        [
                            'title' => 'Tahliah Road Offices',
                            'category' => 'Commercial',
                            'image' => 'images/project/new/9.jpg',
                        ],
                    ];
                ?>

                <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="isotope-item <?php echo e(strtolower($project['category'])); ?>">
                        <div class="project-card">
                            <div class="project-card-image">
                                <img src="<?php echo e(asset($project['image'])); ?>" alt="<?php echo e($project['title']); ?>">
                            </div>
                            <div class="project-card-overlay">
                                <div class="project-card-content">
                                    <span class="project-card-category"><?php echo e($project['category']); ?></span>
                                    <h3 class="project-card-title"><?php echo e($project['title']); ?></h3>
                                    <a href="#" class="project-card-button">
                                        View Project <i class="fas fa-arrow-right"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>
        </div>
    </section>

    <!-- ================== FINAL CTA SECTION ================== -->
    <section class="py-20 bg-white text-center">
        <div class="container mx-auto px-4">
            <h2 class="text-3xl sm:text-4xl font-extrabold text-custom-secondary max-w-3xl mx-auto">
                Have a Project in Mind? Let's Build It Together.
            </h2>
            <p class="mt-4 text-gray-600 max-w-2xl mx-auto">
                Our team is ready to discuss your requirements and provide a tailored solution that meets your goals.
                Contact us today for a consultation or to request a quote.
            </p>
            <a href="/contact"
                class="mt-8 inline-block bg-custom-yellow text-white px-10 py-4 hover:bg-custom-secondary font-bold transition-colors">
                Request a Quote
            </a>
        </div>
    </section>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var grid = document.querySelector('.isotope-grid');
            var iso;

            // Use imagesLoaded to ensure all images are loaded before initializing Isotope
            imagesLoaded(grid, function() {
                // Initialize Isotope
                iso = new Isotope(grid, {
                    itemSelector: '.isotope-item',
                    // THIS IS THE CRITICAL FIX: We are removing layoutMode and masonry options.
                    // This tells Isotope to NOT interfere with the CSS-driven layout.
                    // It will now respect your Tailwind grid classes perfectly.
                    percentPosition: true,
                    transitionDuration: '0.6s'
                });
            });

            // Filter button logic (this part remains the same as it is correct)
            var filtersElem = document.querySelector('#project-filters');
            filtersElem.addEventListener('click', function(event) {
                if (!event.target.matches('button')) {
                    return;
                }
                var filterValue = event.target.getAttribute('data-filter');
                iso.arrange({
                    filter: filterValue
                });

                // Update active button class
                if (filtersElem.querySelector('.is-checked')) {
                    filtersElem.querySelector('.is-checked').classList.remove('is-checked');
                }
                event.target.classList.add('is-checked');
            });
        });
    </script>

<?php $__env->stopSection(); ?>





<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/dbonline/public_html/cesraweb.dunesberry.online/resources/views/projects.blade.php ENDPATH**/ ?>