<?php $__env->startSection('title', 'Insights - Cesra Company Limited'); ?>

<?php $__env->startSection('content'); ?>
    <style>
        /* Specific styles for the blog page */
        .blog-card-image img {
            transition: transform 0.4s ease-out;
        }

        .blog-card:hover .blog-card-image img {
            transform: scale(1.05);
        }

        /* NEW: Styles for the redesigned "Glass" Sidebar */
        .sidebar-widget {
            background: rgba(255, 255, 255, 0.5);
            /* Semi-transparent white for glass effect */
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.7);
            /* border-radius: 0.75rem; */
            /* rounded-xl */
            padding: 1.5rem;
            /* p-6 */
            box-shadow: 0 4px 6px -1px rgb(0 0 0 / 0.05);
        }

        .sidebar-title {
            font-weight: 800;
            /* font-extrabold */
            font-size: 1.25rem;
            /* text-xl */
            color: #2c3a5a;
            /* custom-secondary */
            margin-bottom: 1rem;
            /* mb-4 */
            padding-bottom: 0.75rem;
            /* pb-3 */
            border-bottom: 1px solid #e5e7eb;
            /* border-gray-200 */
        }

        .sidebar-category-link {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0.5rem 0;
            color: #4b5563;
            /* gray-600 */
            transition: color 0.3s ease;
        }

        .sidebar-category-link:hover {
            color: #e82424;
            /* custom-yellow */
        }

        .sidebar-category-link.active {
            color: #e82424;
            /* custom-yellow */
            font-weight: 700;
            /* font-bold */
        }
    </style>
    <!-- ================== REUSABLE PAGE HEADER ================== -->
    <?php if (isset($component)) { $__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.page-header','data' => ['title' => 'Insights','subtitle' => 'Explore the latest news, industry trends, and project updates from the forefront of construction and engineering in Saudi Arabia.','image' => 'images/slider/new/1.jpg']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('page-header'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Insights','subtitle' => 'Explore the latest news, industry trends, and project updates from the forefront of construction and engineering in Saudi Arabia.','image' => 'images/slider/new/1.jpg']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e)): ?>
<?php $attributes = $__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e; ?>
<?php unset($__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e)): ?>
<?php $component = $__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e; ?>
<?php unset($__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e); ?>
<?php endif; ?>

    <!-- ================== BLOG & SIDEBAR SECTION ================== -->
    <section class="py-20 bg-gray-50" x-data="insights_page()" x-init="init()">
        <div class="container mx-auto px-4">
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8 lg:gap-12">

                <!-- Main Content: Blog Posts -->
                <div class="lg:col-span-2">

                    
                    <div class="mb-12 animate-on-scroll">
                        <div class="bg-white shadow-lg overflow-hidden group">
                            <div class="relative">
                                <img src="images/bg/1.jpg" alt="Featured Post" class="w-full h-80 object-cover">
                                <div
                                    class="absolute top-4 left-4 bg-custom-yellow text-white text-xs font-bold uppercase px-3 py-1 rounded">
                                    Featured</div>
                            </div>
                            <div class="p-8">
                                <p class="text-sm text-gray-500 mb-2">Project Updates &bull; June 20, 2025</p>
                                <h2
                                    class="text-3xl font-extrabold text-custom-secondary mb-4 group-hover:text-custom-yellow transition-colors">
                                    <a href="#">CESRA Completes Landmark Shaqra Wastewater Treatment Plant</a>
                                </h2>
                                <p class="text-gray-600 leading-relaxed">A significant leap toward enhancing environmental
                                    sustainability, the successful completion of the Shaqra plant expansion marks a key
                                    milestone in our commitment to Saudi Vision 2030...</p>
                                <a href="#"
                                    class="inline-flex items-center gap-2 font-bold text-custom-secondary mt-6 hover:text-custom-yellow transition-colors">Read
                                    Full Story <i class="fas fa-arrow-right"></i></a>
                            </div>
                        </div>
                    </div>

                    <!-- Regular Blog Post Grid -->
                    <div class="space-y-12">
                        <template x-for="post in paginated_posts" :key="post.id">
                            <div class="blog-card flex flex-col md:flex-row gap-8 bg-white shadow-lg overflow-hidden group animate-on-scroll"
                                x-transition>
                                <div class="md:w-1/3 overflow-hidden blog-card-image">
                                    <a href="#"><img :src="post.image" :alt="post.title"
                                            class="w-full h-64 md:h-full object-cover"></a>
                                </div>
                                <div class="p-8 md:w-2/3">
                                    <div class="flex items-center gap-4 mb-2">
                                        <a href="#" @click.prevent="category_filter = post.category"
                                            class="text-xs font-bold uppercase px-3 py-1 rounded"
                                            :class="post.category === 'Technology' ? 'bg-blue-100 text-blue-800' :
                                                'bg-green-100 text-green-800'"><span
                                                x-text="post.category"></span></a>
                                        <p class="text-sm text-gray-500" x-text="post.date"></p>
                                    </div>
                                    <h3
                                        class="text-2xl font-bold text-custom-secondary mb-3 group-hover:text-custom-yellow transition-colors">
                                        <a href="#" x-text="post.title"></a>
                                    </h3>
                                    <p class="text-gray-600 leading-relaxed" x-text="post.excerpt + '...'"></p>
                                    <a href="#"
                                        class="inline-flex items-center gap-2 font-semibold text-custom-yellow mt-4 hover:underline">Read
                                        More</a>
                                </div>
                            </div>
                        </template>
                    </div>

                    <div x-show="paginated_posts.length === 0"
                        class="text-center py-16 text-gray-500 bg-white rounded-lg shadow-lg">
                        <h3 class="text-2xl font-bold text-custom-secondary">No Posts Found</h3>
                        <p class="mt-2">Try adjusting your search or category filter.</p>
                    </div>

                    <!-- Pagination -->
                    
                </div>

                <!-- ============== NEW, REDESIGNED SIDEBAR ============== -->
                <aside class="lg:col-span-1 space-y-8 animate-on-scroll">
                    <!-- Search Widget -->
                    <div class="sidebar-widget">
                        <h3 class="sidebar-title">Search</h3>
                        <div class="relative">
                            <input type="text" x-model.debounce.300ms="search_term" placeholder="Type to search..."
                                class="w-full border-gray-300 rounded-md shadow-inner focus:ring-custom-yellow focus:border-custom-yellow">
                            <i class="fas fa-search absolute top-1/2 right-4 -translate-y-1/2 text-gray-400"></i>
                        </div>
                    </div>

                    <!-- Categories Widget -->
                    <div class="sidebar-widget">
                        <h3 class="sidebar-title">Categories</h3>
                        <ul class="space-y-1">
                            <li><a @click.prevent="category_filter = 'all'" href="#" class="sidebar-category-link"
                                    :class="{ 'active': category_filter === 'all' }"><span>All</span> <span
                                        x-text="posts.length"></span></a></li>
                            <template x-for="category in categories" :key="category.name">
                                <li><a @click.prevent="category_filter = category.name" href="#"
                                        class="sidebar-category-link"
                                        :class="{ 'active': category_filter === category.name }"><span
                                            x-text="category.name"></span> <span x-text="category.count"></span></a></li>
                            </template>
                        </ul>
                    </div>

                    <!-- Recent Posts Widget -->
                    <div class="sidebar-widget">
                        <h3 class="sidebar-title">Recent Posts</h3>
                        <ul class="space-y-5">
                            <template x-for="post in posts.slice(0, 3)" :key="post.id">
                                <li class="flex items-center gap-4 group">
                                    <a href="#" class="flex-shrink-0 block w-20 h-20 overflow-hidden">
                                        <img :src="post.image" :alt="post.title"
                                            class="w-full h-full object-cover transform group-hover:scale-110 transition-transform duration-300">
                                    </a>
                                    <div>
                                        <p class="text-xs text-gray-500" x-text="post.date"></p>
                                        <a href="#"
                                            class="font-bold text-sm leading-tight text-custom-secondary group-hover:text-custom-yellow transition-colors"
                                            x-text="post.title"></a>
                                    </div>
                                </li>
                            </template>
                        </ul>
                    </div>
                </aside>

            </div>
        </div>
    </section>
    <script>
        function insights_page() {
            return {
                search_term: '',
                category_filter: 'all',
                current_page: 1,
                posts_per_page: 3,
                posts: [{
                        id: 2,
                        title: 'Innovations in Sustainable Construction Materials',
                        category: 'Technology',
                        date: 'June 15, 2025',
                        image: 'images/bg/1.jpg',
                        excerpt: 'Discover how CESRA is integrating next-generation, eco-friendly materials into our projects to reduce carbon footprint and enhance durability'
                    },
                    {
                        id: 3,
                        title: 'The Role of BIM in Modern Project Management',
                        category: 'Technology',
                        date: 'May 28, 2025',
                        image: 'images/bg/2.jpg',
                        excerpt: 'Building Information Modeling (BIM) is revolutionizing how we plan, design, and execute complex construction projects, ensuring precision and efficiency'
                    },
                    {
                        id: 4,
                        title: 'Safety First: Our Unwavering Commitment to HSE Standards',
                        category: 'Company News',
                        date: 'May 10, 2025',
                        image: 'images/bg/3.jpg',
                        excerpt: 'A deep dive into CESRA’s rigorous safety protocols and culture of care that protects our team and ensures project integrity from start to finish'
                    },
                    {
                        id: 5,
                        title: 'NEOM & The Future of Urban Infrastructure in KSA',
                        category: 'Technology',
                        date: 'April 22, 2025',
                        image: 'images/bg/4.jpg',
                        excerpt: 'Analyzing the groundbreaking infrastructure challenges and opportunities presented by giga-projects like NEOM, and how CESRA is poised to contribute'
                    },
                    {
                        id: 6,
                        title: 'CESRA Awarded New Governmental Facilities Contract',
                        category: 'Company News',
                        date: 'April 05, 2025',
                        image: 'images/bg/5.jpg',
                        excerpt: 'We are proud to announce our partnership in constructing a new state-of-the-art administrative complex in Riyadh, furthering our support for national growth'
                    },
                ],

                // --- DATA & COMPUTED PROPERTIES (No longer functions) ---
                get filtered_posts() {
                    let filtered = this.posts;
                    if (this.category_filter !== 'all') {
                        filtered = filtered.filter(p => p.category === this.category_filter);
                    }
                    if (this.search_term.trim() !== '') {
                        filtered = filtered.filter(p =>
                            p.title.toLowerCase().includes(this.search_term.toLowerCase()) ||
                            p.excerpt.toLowerCase().includes(this.search_term.toLowerCase())
                        );
                    }
                    return filtered;
                },

                // 2. A computed property for the total number of pages based on the filtered list.
                get total_pages() {
                    return Math.ceil(this.filtered_posts.length / this.posts_per_page);
                },

                // 3. A computed property that returns ONLY the posts for the current page.
                get paginated_posts() {
                    const start = (this.current_page - 1) * this.posts_per_page;
                    const end = start + this.posts_per_page;
                    return this.filtered_posts.slice(start, end);
                },

                // 4. Simple methods to change the page number.
                next_page() {
                    if (this.current_page < this.total_pages) {
                        this.current_page++;
                    }
                },
                prev_page() {
                    if (this.current_page > 1) {
                        this.current_page--;
                    }
                },

                // 5. Watchers to reset the page number when filters change. This is critical.


                get categories() {
                    const counts = this.posts.reduce((acc, post) => {
                        acc[post.category] = (acc[post.category] || 0) + 1;
                        return acc;
                    }, {});
                    return Object.keys(counts).map(name => ({
                        name,
                        count: counts[name]
                    }));
                },

                // --- METHODS ---
                update_posts() {
                    // 1. Filter by category
                    let posts_by_cat = this.posts;
                    if (this.category_filter !== 'all') {
                        posts_by_cat = this.posts.filter(p => p.category === this.category_filter);
                    }

                    // 2. Filter by search term
                    let posts_by_search = posts_by_cat;
                    if (this.search_term.trim() !== '') {
                        posts_by_search = posts_by_cat.filter(p =>
                            p.title.toLowerCase().includes(this.search_term.toLowerCase()) ||
                            p.excerpt.toLowerCase().includes(this.search_term.toLowerCase())
                        );
                    }

                    this.filtered_posts = posts_by_search;

                    // 3. Update pagination
                    this.total_pages = Math.ceil(this.filtered_posts.length / this.posts_per_page);
                    // Clamp current page to the new total
                    if (this.current_page > this.total_pages) {
                        this.current_page = this.total_pages > 0 ? this.total_pages : 1;
                    }

                    // 4. Slice for pagination
                    const start = (this.current_page - 1) * this.posts_per_page;
                    const end = start + this.posts_per_page;
                    this.paginated_posts = this.filtered_posts.slice(start, end);
                },


                init() {
                    this.$watch('search_term', () => {
                        if (this.current_page !== 1) {
                            this.current_page = 1;
                        }
                    });
                    this.$watch('category_filter', () => {
                        if (this.current_page !== 1) {
                            this.current_page = 1;
                        }
                    });
                }
            }
        }

        // Standard on-scroll animation observer
        document.addEventListener('DOMContentLoaded', () => {
            const animatedElements = document.querySelectorAll('.animate-on-scroll');
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.classList.add('is-visible');
                    }
                });
            }, {
                threshold: 0.1
            });
            animatedElements.forEach(el => observer.observe(el));
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/theroof/cesra/resources/views/insights.blade.php ENDPATH**/ ?>